/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.bench;

import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.DoubleHistogramIterationValue;
import org.HdrHistogram.DoublePercentileIterator;

class HdrHistogramDataSet
extends AbstractDataSet<HdrHistogramDataSet> {
    protected DoubleArrayList x = new DoubleArrayList(1000);
    protected DoubleArrayList y = new DoubleArrayList(1000);
    protected final DoubleHistogram histogram = new DoubleHistogram(2);

    public HdrHistogramDataSet(String string) {
        super(string, 2);
        this.histogram.setAutoResize(true);
    }

    @Override
    public double get(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.x.getDouble(n3);
            }
            case 1: {
                return this.y.getDouble(n3);
            }
        }
        return Double.NaN;
    }

    public void add(double d2) {
        FXUtils.assertJavaFxThread();
        this.histogram.recordValue(d2);
        this.getAxisDescription(1).add(d2);
        this.getAxisDescription(0).fireInvalidated(ChartBits.DataSetRange);
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    @Override
    public DataSet recomputeLimits(int n2) {
        if (this.getBitState().isDirty(ChartBits.DataSetRange)) {
            this.convertHistogramToXY();
        }
        return this.getThis();
    }

    public void convertHistogramToXY() {
        Object object;
        this.x.clear();
        this.y.clear();
        DoublePercentileIterator doublePercentileIterator = new DoublePercentileIterator(this.histogram, 50);
        while (doublePercentileIterator.hasNext()) {
            object = doublePercentileIterator.next();
            this.x.add(HdrHistogramDataSet.convertPercentileToX((DoubleHistogramIterationValue)object));
            this.y.add(((DoubleHistogramIterationValue)object).getValueIteratedTo());
        }
        object = this.getAxisDescription(0);
        if (!this.x.isEmpty()) {
            double d2 = this.x.getDouble(0);
            double d3 = this.x.getDouble(this.x.size() - 1);
            object.set(d2, d3);
        } else {
            object.clear();
        }
        object.getBitState().clear();
        AxisDescription axisDescription = this.getAxisDescription(1);
        axisDescription.set(this.histogram.getMinValue(), this.histogram.getMaxValue());
        axisDescription.getBitState().clear();
        this.getBitState().clear(ChartBits.DataSetRange);
    }

    public static double convertPercentileToX(DoubleHistogramIterationValue doubleHistogramIterationValue) {
        double d2 = doubleHistogramIterationValue.getPercentileLevelIteratedTo();
        if (d2 == 100.0) {
            double d3 = doubleHistogramIterationValue.getTotalCountToThisValue();
            d2 = 100.0 * ((d3 - 1.0) / d3);
        }
        return HdrHistogramDataSet.convertPercentileToX(d2);
    }

    public static double convertPercentileToX(double d2) {
        return 1.0 / (1.0 - d2 / 100.0);
    }

    public static double convertPercentileFromX(double d2) {
        return 100.0 - 100.0 / d2;
    }

    public void clear() {
        this.x.clear();
        this.y.clear();
        this.histogram.reset();
        for (AxisDescription axisDescription : this.getAxisDescriptions()) {
            axisDescription.clear();
        }
    }

    @Override
    public int getDataCount() {
        return this.x.size();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException();
    }
}

