/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi.format;

import io.fair_acc.chartfx.axes.TickUnitSupplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public final class DefaultTickUnitSupplier
implements TickUnitSupplier {
    private static final int BASE = 10;
    private static final SortedSet<Number> DEFAULT_MULTIPLIERS = Collections.unmodifiableSortedSet(new TreeSet<Number>(Arrays.asList(1.0, 2.5, 5.0)));
    private final double[] multipliers;

    public DefaultTickUnitSupplier() {
        this(DEFAULT_MULTIPLIERS);
    }

    public DefaultTickUnitSupplier(SortedSet<? extends Number> sortedSet) {
        Objects.requireNonNull(sortedSet, "The multipliers must not be null");
        if (sortedSet.isEmpty()) {
            throw new IllegalArgumentException("The set of multipliers must not be empty");
        }
        DefaultTickUnitSupplier.checkRange(sortedSet);
        this.multipliers = sortedSet.stream().mapToDouble(Number::doubleValue).toArray();
    }

    @Override
    public double computeTickUnit(double d2) {
        double d3 = Math.abs(d2);
        int n2 = (int)Math.floor(Math.log10(d3));
        double d4 = d3 / Math.pow(10.0, n2);
        double d5 = 0.0;
        int n3 = this.multipliers.length - 1;
        if (d4 > this.multipliers[n3]) {
            ++n2;
            d5 = this.multipliers[0];
        } else {
            for (int i2 = n3; i2 >= 0 && d4 <= this.multipliers[i2]; --i2) {
                d5 = this.multipliers[i2];
            }
        }
        return d5 * Math.pow(10.0, n2);
    }

    private static void checkRange(SortedSet<? extends Number> sortedSet) {
        for (Number number : sortedSet) {
            if (!(number.doubleValue() < 1.0) && !(number.doubleValue() >= 10.0)) continue;
            throw new IllegalArgumentException("The multiplier values must be in range [1, 10)");
        }
    }
}

