/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ErrorCode;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.MultiRcvDestination;
import io.aeron.driver.media.ReceiveChannelEndpointRhsPadding;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import io.aeron.status.LocalSocketAddressStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.agrona.collections.Hashing;
import org.agrona.collections.Int2IntCounterMap;
import org.agrona.collections.Long2LongCounterMap;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class ReceiveChannelEndpoint
extends ReceiveChannelEndpointRhsPadding {
    static final long DESTINATION_ADDRESS_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private final DataPacketDispatcher dispatcher;
    private final ByteBuffer smBuffer;
    private final StatusMessageFlyweight statusMessageFlyweight;
    private final ByteBuffer nakBuffer;
    private final NakFlyweight nakFlyweight;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementFlyweight;
    private final AtomicCounter shortSends;
    private final AtomicCounter possibleTtlAsymmetry;
    private final AtomicCounter statusIndicator;
    private final Int2IntCounterMap refCountByStreamIdMap = new Int2IntCounterMap(0);
    private final Long2LongCounterMap refCountByStreamIdAndSessionIdMap = new Long2LongCounterMap(0L);
    private final MultiRcvDestination multiRcvDestination;
    private final CachedNanoClock cachedNanoClock;
    private final Long groupTag;
    private final boolean isChannelReceiveTimestampEnabled;
    private final EpochNanoClock channelReceiveTimestampClock;
    private final long receiverId;
    private InetSocketAddress currentControlAddress;
    private AtomicCounter localSocketAddressIndicator;
    private int imageRefCount;

    public ReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dataPacketDispatcher, AtomicCounter atomicCounter, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteData(), udpChannel.remoteData(), null, context);
        this.dispatcher = dataPacketDispatcher;
        this.statusIndicator = atomicCounter;
        this.shortSends = context.systemCounters().get(SystemCounterDescriptor.SHORT_SENDS);
        this.possibleTtlAsymmetry = context.systemCounters().get(SystemCounterDescriptor.POSSIBLE_TTL_ASYMMETRY);
        ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals = context.receiveChannelEndpointThreadLocals();
        this.smBuffer = receiveChannelEndpointThreadLocals.statusMessageBuffer();
        this.statusMessageFlyweight = receiveChannelEndpointThreadLocals.statusMessageFlyweight();
        this.nakBuffer = receiveChannelEndpointThreadLocals.nakBuffer();
        this.nakFlyweight = receiveChannelEndpointThreadLocals.nakFlyweight();
        this.rttMeasurementBuffer = receiveChannelEndpointThreadLocals.rttMeasurementBuffer();
        this.rttMeasurementFlyweight = receiveChannelEndpointThreadLocals.rttMeasurementFlyweight();
        this.cachedNanoClock = context.receiverCachedNanoClock();
        this.timeOfLastActivityNs = this.cachedNanoClock.nanoTime();
        this.receiverId = receiveChannelEndpointThreadLocals.nextReceiverId();
        this.groupTag = null == udpChannel.groupTag() ? context.receiverGroupTag() : udpChannel.groupTag();
        this.multiRcvDestination = udpChannel.isManualControlMode() ? new MultiRcvDestination() : null;
        this.currentControlAddress = udpChannel.localControl();
        this.channelReceiveTimestampClock = context.channelReceiveTimestampClock();
        this.isChannelReceiveTimestampEnabled = udpChannel.isChannelReceiveTimestampEnabled();
    }

    public void localSocketAddressIndicator(AtomicCounter atomicCounter) {
        if (null != this.multiRcvDestination) {
            throw new IllegalStateException("local socket address indicator not used for MDS");
        }
        this.localSocketAddressIndicator = atomicCounter;
    }

    public int sendTo(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        try {
            if (null != this.sendDatagramChannel && this.sendDatagramChannel.isOpen()) {
                this.sendHook(byteBuffer, inetSocketAddress);
                n3 = this.sendDatagramChannel.send(byteBuffer, inetSocketAddress);
            }
        }
        catch (IOException iOException) {
            ReceiveChannelEndpoint.sendError(n2, iOException, inetSocketAddress);
        }
        return n3;
    }

    public String originalUriString() {
        return this.subscriptionUdpChannel().originalUriString();
    }

    public AtomicCounter statusIndicatorCounter() {
        return this.statusIndicator;
    }

    public void indicateActive() {
        long l2 = this.statusIndicator.get();
        if (l2 != 0L) {
            throw new AeronException("channel cannot be registered unless INITIALIZING: status=" + ChannelEndpointStatus.status(l2));
        }
        if (null == this.multiRcvDestination) {
            String string = this.bindAddressAndPort();
            this.statusIndicator.appendToLabel(string);
            this.updateLocalSocketAddress(string);
        }
        this.statusIndicator.setOrdered(1L);
    }

    public void closeIndicators() {
        this.statusIndicator.close();
        if (null != this.localSocketAddressIndicator) {
            this.localSocketAddressIndicator.close();
        }
    }

    public void closeMultiRcvDestinationTransports(DataTransportPoller dataTransportPoller) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.closeTransports(dataTransportPoller);
        }
    }

    public void closeMultiRcvDestinationIndicators(DriverConductorProxy driverConductorProxy) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.closeIndicators(driverConductorProxy);
        }
    }

    public void openChannel(DriverConductorProxy driverConductorProxy) {
        if (null == this.multiRcvDestination) {
            if (driverConductorProxy.notConcurrent()) {
                this.openDatagramChannel(this.statusIndicator);
            } else {
                try {
                    this.openDatagramChannel(this.statusIndicator);
                }
                catch (Exception exception) {
                    driverConductorProxy.channelEndpointError(this.statusIndicator.id(), exception);
                    throw exception;
                }
            }
        }
    }

    public void possibleTtlAsymmetryEncountered() {
        this.possibleTtlAsymmetry.incrementOrdered();
    }

    public int incRefToStream(int n2) {
        return this.refCountByStreamIdMap.incrementAndGet(n2);
    }

    public int decRefToStream(int n2) {
        int n3 = this.refCountByStreamIdMap.decrementAndGet(n2);
        if (-1 == n3) {
            this.refCountByStreamIdMap.remove(n2);
            throw new IllegalStateException("unknown stream Id: " + n2);
        }
        return n3;
    }

    public long incRefToStreamAndSession(int n2, int n3) {
        return this.refCountByStreamIdAndSessionIdMap.incrementAndGet(Hashing.compoundKey(n2, n3));
    }

    public long decRefToStreamAndSession(int n2, int n3) {
        long l2 = Hashing.compoundKey(n2, n3);
        long l3 = this.refCountByStreamIdAndSessionIdMap.decrementAndGet(l2);
        if (-1L == l3) {
            this.refCountByStreamIdAndSessionIdMap.remove(l2);
            throw new IllegalStateException("unknown stream Id + session Id: " + n2 + " " + n3);
        }
        return l3;
    }

    public int distinctSubscriptionCount() {
        return this.refCountByStreamIdMap.size() + this.refCountByStreamIdAndSessionIdMap.size();
    }

    public boolean shouldBeClosed() {
        return this.refCountByStreamIdMap.isEmpty() && this.refCountByStreamIdAndSessionIdMap.isEmpty() && !this.statusIndicator.isClosed() && this.imageRefCount <= 0;
    }

    public boolean hasExplicitControl() {
        return this.udpChannel.hasExplicitControl();
    }

    public InetSocketAddress explicitControlAddress() {
        return this.udpChannel.hasExplicitControl() ? this.currentControlAddress : null;
    }

    public boolean hasDestinationControl() {
        return null != this.multiRcvDestination;
    }

    public void validateAllowsDestinationControl() {
        if (null == this.multiRcvDestination) {
            throw new ControlProtocolException(ErrorCode.INVALID_CHANNEL, "channel does not allow manual control");
        }
    }

    @Override
    public boolean isMulticast() {
        return this.isMulticast(0);
    }

    public boolean isMulticast(int n2) {
        if (null != this.multiRcvDestination) {
            return this.multiRcvDestination.transport(n2).isMulticast();
        }
        if (0 == n2) {
            return super.isMulticast();
        }
        throw new IllegalStateException("isMulticast for unknown index " + n2);
    }

    public UdpChannel subscriptionUdpChannel() {
        return this.udpChannel;
    }

    @Override
    public UdpChannel udpChannel() {
        return this.udpChannel(0);
    }

    public UdpChannel udpChannel(int n2) {
        if (null != this.multiRcvDestination && this.multiRcvDestination.hasDestination(n2)) {
            return this.multiRcvDestination.transport(n2).udpChannel();
        }
        if (0 == n2) {
            return super.udpChannel();
        }
        throw new IllegalStateException("udpChannel for unknown index " + n2);
    }

    public boolean hasTag() {
        return this.udpChannel.hasTag();
    }

    public long tag() {
        return this.udpChannel.tag();
    }

    public boolean matchesTag(UdpChannel udpChannel) {
        return this.udpChannel.matchesTag(udpChannel);
    }

    @Override
    public int multicastTtl() {
        return this.multicastTtl(0);
    }

    public int multicastTtl(int n2) {
        if (null != this.multiRcvDestination) {
            return this.multiRcvDestination.transport(n2).multicastTtl();
        }
        if (0 == n2) {
            return super.multicastTtl();
        }
        throw new IllegalStateException("multicastTtl for unknown index " + n2);
    }

    public int addDestination(ReceiveDestinationTransport receiveDestinationTransport) {
        return this.multiRcvDestination.addDestination(receiveDestinationTransport);
    }

    public void removeDestination(int n2) {
        this.multiRcvDestination.removeDestination(n2);
    }

    public int destination(UdpChannel udpChannel) {
        return this.multiRcvDestination.transport(udpChannel);
    }

    public ReceiveDestinationTransport destination(int n2) {
        return this.multiRcvDestination.transport(n2);
    }

    public boolean hasDestination(int n2) {
        return null == this.multiRcvDestination ? 0 == n2 : this.multiRcvDestination.hasDestination(n2);
    }

    public int onDataPacket(DataHeaderFlyweight dataHeaderFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        if (this.isChannelReceiveTimestampEnabled) {
            this.applyChannelReceiveTimestamp(unsafeBuffer, n2);
        }
        this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), n3);
        return this.dispatcher.onDataPacket(this, dataHeaderFlyweight, unsafeBuffer, n2, inetSocketAddress, n3);
    }

    public void onSetupMessage(SetupFlyweight setupFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), n3);
        this.dispatcher.onSetupMessage(this, setupFlyweight, inetSocketAddress, n3);
    }

    public void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        long l2 = rttMeasurementFlyweight.receiverId();
        if (l2 == this.receiverId || l2 == 0L) {
            this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), n3);
            this.dispatcher.onRttMeasurement(this, rttMeasurementFlyweight, inetSocketAddress, n3);
        }
    }

    public void sendSetupElicitingStatusMessage(int n2, InetSocketAddress inetSocketAddress, int n3, int n4) {
        this.smBuffer.clear();
        this.statusMessageFlyweight.sessionId(n3).streamId(n4).consumptionTermId(0).consumptionTermOffset(0).receiverWindowLength(0).receiverId(this.receiverId).groupTag(this.groupTag).flags((short)128);
        this.smBuffer.limit(this.statusMessageFlyweight.frameLength());
        this.send(this.smBuffer, this.statusMessageFlyweight.frameLength(), n2, inetSocketAddress);
    }

    public void sendRttMeasurement(int n2, InetSocketAddress inetSocketAddress, int n3, int n4, long l2, long l3, boolean bl2) {
        this.rttMeasurementBuffer.clear();
        this.rttMeasurementFlyweight.sessionId(n3).streamId(n4).receiverId(this.receiverId).echoTimestampNs(l2).receptionDelta(l3).flags(bl2 ? (short)128 : 0);
        this.send(this.rttMeasurementBuffer, 40, n2, inetSocketAddress);
    }

    public void sendStatusMessage(ImageConnection[] imageConnectionArray, int n2, int n3, int n4, int n5, int n6, short s2) {
        this.smBuffer.clear();
        this.statusMessageFlyweight.sessionId(n2).streamId(n3).consumptionTermId(n4).consumptionTermOffset(n5).receiverWindowLength(n6).receiverId(this.receiverId).groupTag(this.groupTag).flags(s2);
        this.smBuffer.limit(this.statusMessageFlyweight.frameLength());
        this.send(this.smBuffer, this.statusMessageFlyweight.frameLength(), imageConnectionArray);
    }

    public void sendNakMessage(ImageConnection[] imageConnectionArray, int n2, int n3, int n4, int n5, int n6) {
        this.nakBuffer.clear();
        this.nakFlyweight.streamId(n3).sessionId(n2).termId(n4).termOffset(n5).length(n6);
        this.send(this.nakBuffer, 28, imageConnectionArray);
    }

    public void sendRttMeasurement(ImageConnection[] imageConnectionArray, int n2, int n3, long l2, long l3, boolean bl2) {
        this.rttMeasurementBuffer.clear();
        this.rttMeasurementFlyweight.sessionId(n2).streamId(n3).receiverId(this.receiverId).echoTimestampNs(l2).receptionDelta(l3).flags(bl2 ? (short)128 : 0);
        this.send(this.rttMeasurementBuffer, 40, imageConnectionArray);
    }

    public DataPacketDispatcher dispatcher() {
        return this.dispatcher;
    }

    public void updateControlAddress(int n2, InetSocketAddress inetSocketAddress) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.updateControlAddress(n2, inetSocketAddress);
        } else if (this.udpChannel.hasExplicitControl()) {
            this.currentControlAddress = inetSocketAddress;
        }
    }

    protected void send(ByteBuffer byteBuffer, int n2, ImageConnection[] imageConnectionArray) {
        int n3;
        int n4 = n3 = null == this.multiRcvDestination ? this.sendTo(byteBuffer, imageConnectionArray[0].controlAddress) : this.multiRcvDestination.sendToAll(imageConnectionArray, byteBuffer, n2, this.cachedNanoClock.nanoTime());
        if (n2 != n3) {
            this.shortSends.increment();
        }
    }

    protected void send(ByteBuffer byteBuffer, int n2, int n3, InetSocketAddress inetSocketAddress) {
        int n4;
        int n5 = n4 = null == this.multiRcvDestination ? this.sendTo(byteBuffer, inetSocketAddress) : MultiRcvDestination.sendTo(this.multiRcvDestination.transport(n3), byteBuffer, inetSocketAddress);
        if (n2 != n4) {
            this.shortSends.increment();
        }
    }

    void checkForReResolution(long l2, DriverConductorProxy driverConductorProxy) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.checkForReResolution(this, l2, driverConductorProxy);
        } else if (this.udpChannel.hasExplicitControl() && this.timeOfLastActivityNs + DESTINATION_ADDRESS_TIMEOUT - l2 < 0L) {
            this.timeOfLastActivityNs = l2;
            driverConductorProxy.reResolveControl(this.udpChannel.channelUri().get("control"), this.udpChannel, this, this.currentControlAddress);
        }
    }

    public void incRefImages() {
        ++this.imageRefCount;
    }

    public void decRefImages() {
        --this.imageRefCount;
    }

    private void updateTimeOfLastActivityNs(long l2, int n2) {
        if (null == this.multiRcvDestination) {
            this.timeOfLastActivityNs = l2;
        } else {
            this.multiRcvDestination.transport(n2).timeOfLastActivityNs(l2);
        }
    }

    private void updateLocalSocketAddress(String string) {
        if (null != this.localSocketAddressIndicator) {
            LocalSocketAddressStatus.updateBindAddress(this.localSocketAddressIndicator, string, this.context.countersMetaDataBuffer());
            this.localSocketAddressIndicator.setOrdered(1L);
        }
    }

    private void applyChannelReceiveTimestamp(UnsafeBuffer unsafeBuffer, int n2) {
        int n3;
        if (n2 > 32 && 32 + (n3 = this.udpChannel.channelReceiveTimestampOffset()) + 8 < n2) {
            unsafeBuffer.putLong(32 + n3, this.channelReceiveTimestampClock.nanoTime(), ByteOrder.LITTLE_ENDIAN);
        }
    }
}

