/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverEventsAdapter;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.LogBuffers;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ChannelEndpointException;
import io.aeron.exceptions.ClientTimeoutException;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.status.HeartbeatTimestamp;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.UnsafeBufferPosition;

final class ClientConductor
implements Agent {
    private static final long NO_CORRELATION_ID = -1L;
    private static final long EXPLICIT_CLOSE_LINGER_NS = TimeUnit.SECONDS.toNanos(1L);
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private long timeOfLastKeepAliveNs;
    private long timeOfLastServiceNs;
    private boolean isClosed;
    private boolean isInCallback;
    private boolean isTerminating;
    private RegistrationException driverException;
    private final Aeron.Context ctx;
    private final Aeron aeron;
    private final Lock clientLock;
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final IdleStrategy awaitingIdleStrategy;
    private final DriverEventsAdapter driverEventsAdapter;
    private final LogBuffersFactory logBuffersFactory;
    private final Long2ObjectHashMap<LogBuffers> logBuffersByIdMap = new Long2ObjectHashMap();
    private final ArrayList<LogBuffers> lingeringLogBuffers = new ArrayList();
    private final Long2ObjectHashMap<Object> resourceByRegIdMap = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<RegistrationException> asyncExceptionByRegIdMap = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<String> stashedChannelByRegistrationId = new Long2ObjectHashMap();
    private final LongHashSet asyncCommandIdSet = new LongHashSet();
    private final AvailableImageHandler defaultAvailableImageHandler;
    private final UnavailableImageHandler defaultUnavailableImageHandler;
    private final Long2ObjectHashMap<AvailableCounterHandler> availableCounterHandlerById = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<UnavailableCounterHandler> unavailableCounterHandlerById = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<Runnable> closeHandlerByIdMap = new Long2ObjectHashMap();
    private final DriverProxy driverProxy;
    private final AgentInvoker driverAgentInvoker;
    private final UnsafeBuffer counterValuesBuffer;
    private final CountersReader countersReader;
    private AtomicCounter heartbeatTimestamp;

    ClientConductor(Aeron.Context context, Aeron aeron) {
        long l2;
        this.ctx = context;
        this.aeron = aeron;
        this.clientLock = context.clientLock();
        this.epochClock = context.epochClock();
        this.nanoClock = context.nanoClock();
        this.awaitingIdleStrategy = context.awaitingIdleStrategy();
        this.driverProxy = context.driverProxy();
        this.logBuffersFactory = context.logBuffersFactory();
        this.keepAliveIntervalNs = context.keepAliveIntervalNs();
        this.driverTimeoutMs = context.driverTimeoutMs();
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.driverTimeoutMs);
        this.interServiceTimeoutNs = context.interServiceTimeoutNs();
        this.defaultAvailableImageHandler = context.availableImageHandler();
        this.defaultUnavailableImageHandler = context.unavailableImageHandler();
        this.driverEventsAdapter = new DriverEventsAdapter(context.clientId(), context.toClientBuffer(), this, this.asyncCommandIdSet);
        this.driverAgentInvoker = context.driverAgentInvoker();
        this.counterValuesBuffer = context.countersValuesBuffer();
        this.countersReader = new CountersReader(context.countersMetaDataBuffer(), context.countersValuesBuffer(), StandardCharsets.US_ASCII);
        if (null != context.availableCounterHandler()) {
            this.availableCounterHandlerById.put(aeron.nextCorrelationId(), context.availableCounterHandler());
        }
        if (null != context.unavailableCounterHandler()) {
            this.unavailableCounterHandlerById.put(aeron.nextCorrelationId(), context.unavailableCounterHandler());
        }
        if (null != context.closeHandler()) {
            this.closeHandlerByIdMap.put(aeron.nextCorrelationId(), context.closeHandler());
        }
        this.timeOfLastKeepAliveNs = l2 = this.nanoClock.nanoTime();
        this.timeOfLastServiceNs = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose() {
        block9: {
            boolean bl2 = false;
            this.clientLock.lock();
            try {
                if (this.isClosed) break block9;
                if (!this.aeron.isClosed()) {
                    this.aeron.internalClose();
                }
                boolean bl3 = this.isTerminating;
                this.isTerminating = true;
                this.forceCloseResources();
                this.notifyCloseHandlers();
                try {
                    if (bl3) {
                        Thread.sleep(16L);
                    }
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.ctx.closeLingerDurationNs()));
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                for (LogBuffers logBuffers : this.lingeringLogBuffers) {
                    CloseHelper.close(this.ctx.errorHandler(), logBuffers);
                }
                this.driverProxy.clientClose();
                this.ctx.close();
                this.ctx.countersMetaDataBuffer().wrap(0L, 0);
                this.ctx.countersValuesBuffer().wrap(0L, 0);
            }
            finally {
                this.isClosed = true;
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                this.clientLock.unlock();
            }
        }
    }

    @Override
    public int doWork() {
        int n2 = 0;
        if (this.clientLock.tryLock()) {
            try {
                if (this.isTerminating) {
                    throw new AgentTerminationException();
                }
                n2 = this.service(-1L);
            }
            finally {
                this.clientLock.unlock();
            }
        }
        return n2;
    }

    @Override
    public String roleName() {
        return "aeron-client-conductor";
    }

    boolean isClosed() {
        return this.isClosed;
    }

    boolean isTerminating() {
        return this.isTerminating;
    }

    void onError(long l2, int n2, ErrorCode errorCode, String string) {
        this.driverException = new RegistrationException(l2, n2, errorCode, string);
        Object object = this.resourceByRegIdMap.get(l2);
        if (object instanceof Subscription) {
            Subscription subscription = (Subscription)object;
            subscription.internalClose(-1L);
            this.resourceByRegIdMap.remove(l2);
        }
    }

    void onAsyncError(long l2, int n2, ErrorCode errorCode, String string) {
        this.stashedChannelByRegistrationId.remove(l2);
        RegistrationException registrationException = new RegistrationException(l2, n2, errorCode, string);
        this.asyncExceptionByRegIdMap.put(l2, registrationException);
    }

    void onChannelEndpointError(long l2, String string) {
        int n2 = (int)l2;
        for (Object e2 : this.resourceByRegIdMap.values()) {
            if (e2 instanceof Subscription) {
                if (((Subscription)e2).channelStatusId() != n2) continue;
                this.handleError(new ChannelEndpointException(n2, string));
                continue;
            }
            if (!(e2 instanceof Publication) || ((Publication)e2).channelStatusId() != n2) continue;
            this.handleError(new ChannelEndpointException(n2, string));
        }
        if (this.asyncCommandIdSet.remove(l2)) {
            this.stashedChannelByRegistrationId.remove(l2);
            this.handleError(new RegistrationException(l2, ErrorCode.CHANNEL_ENDPOINT_ERROR.value(), ErrorCode.CHANNEL_ENDPOINT_ERROR, string));
        }
    }

    void onNewPublication(long l2, long l3, int n2, int n3, int n4, int n5, String string) {
        String string2 = this.stashedChannelByRegistrationId.remove(l2);
        ConcurrentPublication concurrentPublication = new ConcurrentPublication(this, string2, n2, n3, new UnsafeBufferPosition(this.counterValuesBuffer, n4), n5, this.logBuffers(l3, string, string2), l3, l2);
        this.resourceByRegIdMap.put(l2, (Object)concurrentPublication);
    }

    void onNewExclusivePublication(long l2, long l3, int n2, int n3, int n4, int n5, String string) {
        if (l2 != l3) {
            this.handleError(new IllegalStateException("correlationId=" + l2 + " registrationId=" + l3));
        }
        String string2 = this.stashedChannelByRegistrationId.remove(l2);
        ExclusivePublication exclusivePublication = new ExclusivePublication(this, string2, n2, n3, new UnsafeBufferPosition(this.counterValuesBuffer, n4), n5, this.logBuffers(l3, string, string2), l3, l2);
        this.resourceByRegIdMap.put(l2, (Object)exclusivePublication);
    }

    void onNewSubscription(long l2, int n2) {
        Subscription subscription;
        Object object = this.resourceByRegIdMap.get(l2);
        if (object instanceof PendingSubscription) {
            subscription = ((PendingSubscription)object).subscription;
            this.resourceByRegIdMap.put(l2, (Object)subscription);
        } else {
            subscription = (Subscription)object;
        }
        subscription.channelStatusId(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAvailableImage(long l2, int n2, long l3, int n3, String string, String string2) {
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(l3);
        if (null != subscription) {
            Image image = new Image(subscription, n2, new UnsafeBufferPosition(this.counterValuesBuffer, n3), this.logBuffers(l2, string, subscription.channel()), this.ctx.subscriberErrorHandler(), string2, l2);
            subscription.addImage(image);
            AvailableImageHandler availableImageHandler = subscription.availableImageHandler();
            if (null != availableImageHandler) {
                this.isInCallback = true;
                try {
                    availableImageHandler.onAvailableImage(image);
                }
                catch (Exception exception) {
                    this.handleError(exception);
                }
                finally {
                    this.isInCallback = false;
                }
            }
        }
    }

    void onUnavailableImage(long l2, long l3) {
        UnavailableImageHandler unavailableImageHandler;
        Image image;
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(l3);
        if (null != subscription && null != (image = subscription.removeImage(l2)) && null != (unavailableImageHandler = subscription.unavailableImageHandler())) {
            this.notifyImageUnavailable(unavailableImageHandler, image);
        }
    }

    void onNewCounter(long l2, int n2) {
        this.resourceByRegIdMap.put(l2, (Object)new Counter(l2, this, this.counterValuesBuffer, n2));
        this.onAvailableCounter(l2, n2);
    }

    void onAvailableCounter(long l2, int n2) {
        for (AvailableCounterHandler availableCounterHandler : this.availableCounterHandlerById.values()) {
            this.notifyCounterAvailable(l2, n2, availableCounterHandler);
        }
    }

    void onUnavailableCounter(long l2, int n2) {
        this.notifyUnavailableCounterHandlers(l2, n2);
    }

    void onClientTimeout() {
        if (!this.isClosed) {
            this.isTerminating = true;
            this.forceCloseResources();
            this.handleError(new ClientTimeoutException("client timeout from driver"));
        }
    }

    CountersReader countersReader() {
        return this.countersReader;
    }

    void handleError(Throwable throwable) {
        if (!this.isClosed) {
            this.ctx.errorHandler().onError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentPublication addPublication(String string, int n2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addPublication(string, n2);
            this.stashedChannelByRegistrationId.put(l2, string);
            this.awaitResponse(l2);
            ConcurrentPublication concurrentPublication = (ConcurrentPublication)this.resourceByRegIdMap.get(l2);
            return concurrentPublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExclusivePublication addExclusivePublication(String string, int n2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addExclusivePublication(string, n2);
            this.stashedChannelByRegistrationId.put(l2, string);
            this.awaitResponse(l2);
            ExclusivePublication exclusivePublication = (ExclusivePublication)this.resourceByRegIdMap.get(l2);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddPublication(String string, int n2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addPublication(string, n2);
            this.stashedChannelByRegistrationId.put(l2, string);
            this.asyncCommandIdSet.add(l2);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddExclusivePublication(String string, int n2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addExclusivePublication(string, n2);
            this.stashedChannelByRegistrationId.put(l2, string);
            this.asyncCommandIdSet.add(l2);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentPublication getPublication(long l2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(l2)) {
                this.service(-1L);
            }
            ConcurrentPublication concurrentPublication = this.resourceOrThrow(l2, ConcurrentPublication.class);
            return concurrentPublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExclusivePublication getExclusivePublication(long l2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(l2)) {
                this.service(-1L);
            }
            ExclusivePublication exclusivePublication = this.resourceOrThrow(l2, ExclusivePublication.class);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void removePublication(Publication publication) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            if (!publication.isClosed()) {
                this.ensureNotReentrant();
                publication.internalClose();
                if (publication == this.resourceByRegIdMap.remove(publication.registrationId())) {
                    this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId(), EXPLICIT_CLOSE_LINGER_NS);
                    this.asyncCommandIdSet.add(this.driverProxy.removePublication(publication.registrationId()));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePublication(long l2) {
        this.clientLock.lock();
        try {
            if (-1L == l2 || this.isTerminating || this.isClosed) {
                return;
            }
            this.ensureNotReentrant();
            Object object = this.resourceByRegIdMap.get(l2);
            if (null != object && !(object instanceof Publication)) {
                throw new AeronException("registration id is not a Publication");
            }
            Publication publication = (Publication)object;
            if (null != publication) {
                this.resourceByRegIdMap.remove(l2);
                publication.internalClose();
                this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId(), EXPLICIT_CLOSE_LINGER_NS);
            }
            if (this.asyncCommandIdSet.remove(l2) || null != publication) {
                this.driverProxy.removePublication(l2);
                this.stashedChannelByRegistrationId.remove(l2);
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    Subscription addSubscription(String string, int n2) {
        return this.addSubscription(string, n2, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription addSubscription(String string, int n2, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addSubscription(string, n2);
            Subscription subscription = new Subscription(this, string, n2, l2, availableImageHandler, unavailableImageHandler);
            this.resourceByRegIdMap.put(l2, (Object)subscription);
            this.awaitResponse(l2);
            Subscription subscription2 = subscription;
            return subscription2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    long asyncAddSubscription(String string, int n2) {
        return this.asyncAddSubscription(string, n2, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddSubscription(String string, int n2, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.driverProxy.addSubscription(string, n2);
            PendingSubscription pendingSubscription = new PendingSubscription(new Subscription(this, string, n2, l2, availableImageHandler, unavailableImageHandler));
            this.resourceByRegIdMap.put(l2, (Object)pendingSubscription);
            this.asyncCommandIdSet.add(l2);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription getSubscription(long l2) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(l2)) {
                this.service(-1L);
            }
            Subscription subscription = this.resourceOrThrow(l2, Subscription.class);
            return subscription;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(Subscription subscription) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            if (!subscription.isClosed()) {
                this.ensureNotReentrant();
                subscription.internalClose(EXPLICIT_CLOSE_LINGER_NS);
                long l2 = subscription.registrationId();
                if (subscription == this.resourceByRegIdMap.remove(l2)) {
                    this.asyncCommandIdSet.add(this.driverProxy.removeSubscription(l2));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addDestination(l2, string));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeDestination(l2, string));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRcvDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addRcvDestination(l2, string));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRcvDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeRcvDestination(l2, string));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l3 = this.driverProxy.addDestination(l2, string);
            this.asyncCommandIdSet.add(l3);
            long l4 = l3;
            return l4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncRemoveDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l3 = this.driverProxy.removeDestination(l2, string);
            this.asyncCommandIdSet.add(l3);
            long l4 = l3;
            return l4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddRcvDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l3 = this.driverProxy.addRcvDestination(l2, string);
            this.asyncCommandIdSet.add(l3);
            long l4 = l3;
            return l4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncRemoveRcvDestination(long l2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l3 = this.driverProxy.removeRcvDestination(l2, string);
            this.asyncCommandIdSet.add(l3);
            long l4 = l3;
            return l4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCommandActive(long l2) {
        this.clientLock.lock();
        try {
            if (this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.ensureActive();
            if (this.asyncCommandIdSet.contains(l2)) {
                this.service(-1L);
            }
            boolean bl3 = this.asyncCommandIdSet.contains(l2);
            return bl3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    boolean hasActiveCommands() {
        this.clientLock.lock();
        try {
            if (this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.ensureActive();
            boolean bl3 = !this.asyncCommandIdSet.isEmpty();
            return bl3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (n4 < 0 || n4 > 112) {
                throw new IllegalArgumentException("key length out of bounds: " + n4);
            }
            if (n6 < 0 || n6 > 380) {
                throw new IllegalArgumentException("label length out of bounds: " + n6);
            }
            long l2 = this.driverProxy.addCounter(n2, directBuffer, n3, n4, directBuffer2, n5, n6);
            this.awaitResponse(l2);
            Counter counter = (Counter)this.resourceByRegIdMap.get(l2);
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int n2, String string) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (string.length() > 380) {
                throw new IllegalArgumentException("label length exceeds MAX_LABEL_LENGTH: " + string.length());
            }
            long l2 = this.driverProxy.addCounter(n2, string);
            this.awaitResponse(l2);
            Counter counter = (Counter)this.resourceByRegIdMap.get(l2);
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addAvailableCounterHandler(AvailableCounterHandler availableCounterHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.aeron.nextCorrelationId();
            this.availableCounterHandlerById.put(l2, availableCounterHandler);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAvailableCounterHandler(long l2) {
        this.clientLock.lock();
        try {
            boolean bl2 = this.availableCounterHandlerById.remove(l2) != null;
            return bl2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAvailableCounterHandler(AvailableCounterHandler availableCounterHandler) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator valueIterator = this.availableCounterHandlerById.values().iterator();
            while (valueIterator.hasNext()) {
                if (availableCounterHandler != valueIterator.next()) continue;
                valueIterator.remove();
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addUnavailableCounterHandler(UnavailableCounterHandler unavailableCounterHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.aeron.nextCorrelationId();
            this.unavailableCounterHandlerById.put(l2, unavailableCounterHandler);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnavailableCounterHandler(long l2) {
        this.clientLock.lock();
        try {
            boolean bl2 = this.unavailableCounterHandlerById.remove(l2) != null;
            return bl2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnavailableCounterHandler(UnavailableCounterHandler unavailableCounterHandler) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator valueIterator = this.unavailableCounterHandlerById.values().iterator();
            while (valueIterator.hasNext()) {
                if (unavailableCounterHandler != valueIterator.next()) continue;
                valueIterator.remove();
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addCloseHandler(Runnable runnable) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long l2 = this.aeron.nextCorrelationId();
            this.closeHandlerByIdMap.put(l2, runnable);
            long l3 = l2;
            return l3;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseHandler(long l2) {
        this.clientLock.lock();
        try {
            boolean bl2 = this.closeHandlerByIdMap.remove(l2) != null;
            return bl2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseHandler(Runnable runnable) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator valueIterator = this.closeHandlerByIdMap.values().iterator();
            while (valueIterator.hasNext()) {
                if (runnable != valueIterator.next()) continue;
                valueIterator.remove();
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCounter(Counter counter) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            this.ensureNotReentrant();
            long l2 = counter.registrationId();
            if (counter == this.resourceByRegIdMap.remove(l2)) {
                this.asyncCommandIdSet.add(this.driverProxy.removeCounter(l2));
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void releaseLogBuffers(LogBuffers logBuffers, long l2, long l3) {
        if (logBuffers.decRef() == 0) {
            this.lingeringLogBuffers.add(logBuffers);
            this.logBuffersByIdMap.remove(l2);
            long l4 = -1L == l3 ? this.ctx.resourceLingerDurationNs() : l3;
            logBuffers.lingerDeadlineNs(this.nanoClock.nanoTime() + l4);
        }
    }

    DriverEventsAdapter driverListenerAdapter() {
        return this.driverEventsAdapter;
    }

    long channelStatus(int n2) {
        switch (n2) {
            case 0: {
                return 0L;
            }
            case -1: {
                return 1L;
            }
        }
        return this.countersReader.getCounterValue(n2);
    }

    void closeImages(Image[] imageArray, UnavailableImageHandler unavailableImageHandler, long l2) {
        for (Image image : imageArray) {
            image.close();
        }
        for (Image image : imageArray) {
            this.releaseLogBuffers(image.logBuffers(), image.correlationId(), l2);
        }
        if (null != unavailableImageHandler) {
            for (Image image : imageArray) {
                this.notifyImageUnavailable(unavailableImageHandler, image);
            }
        }
    }

    private void ensureActive() {
        if (this.isClosed) {
            throw new AeronException("Aeron client is closed");
        }
        if (this.isTerminating) {
            throw new AeronException("Aeron client is terminating");
        }
    }

    private void ensureNotReentrant() {
        if (this.isInCallback) {
            throw new AeronException("reentrant calls not permitted during callbacks");
        }
    }

    private LogBuffers logBuffers(long l2, String string, String string2) {
        LogBuffers logBuffers = this.logBuffersByIdMap.get(l2);
        if (null == logBuffers) {
            logBuffers = this.logBuffersFactory.map(string);
            if (this.ctx.preTouchMappedMemory() && !string2.contains("sparse=true")) {
                logBuffers.preTouch();
            }
            this.logBuffersByIdMap.put(l2, logBuffers);
        }
        logBuffers.incRef();
        return logBuffers;
    }

    private int service(long l2) {
        int n2 = 0;
        try {
            n2 += this.checkTimeouts(this.nanoClock.nanoTime());
            n2 += this.driverEventsAdapter.receive(l2);
        }
        catch (AgentTerminationException agentTerminationException) {
            if (ClientConductor.isClientApiCall(l2)) {
                this.isTerminating = true;
                this.forceCloseResources();
            }
            throw agentTerminationException;
        }
        catch (Exception exception) {
            if (this.driverEventsAdapter.isInvalid()) {
                this.isTerminating = true;
                this.forceCloseResources();
                if (!ClientConductor.isClientApiCall(l2)) {
                    throw new AeronException("Driver events adapter is invalid", exception);
                }
            }
            if (ClientConductor.isClientApiCall(l2)) {
                throw exception;
            }
            this.handleError(exception);
        }
        return n2;
    }

    private static boolean isClientApiCall(long l2) {
        return l2 != -1L;
    }

    private void awaitResponse(long l2) {
        long l3 = this.nanoClock.nanoTime();
        long l4 = l3 + this.driverTimeoutNs;
        this.checkTimeouts(l3);
        this.awaitingIdleStrategy.reset();
        do {
            if (null == this.driverAgentInvoker) {
                this.awaitingIdleStrategy.idle();
            } else {
                this.driverAgentInvoker.invoke();
            }
            this.service(l2);
            if (this.driverEventsAdapter.receivedCorrelationId() == l2) {
                this.stashedChannelByRegistrationId.remove(l2);
                RegistrationException registrationException = this.driverException;
                if (null != registrationException) {
                    this.driverException = null;
                    throw registrationException;
                }
                return;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            this.isTerminating = true;
            throw new AeronException("unexpected interrupt");
        } while (l4 - this.nanoClock.nanoTime() > 0L);
        throw new DriverTimeoutException("no response from MediaDriver within " + this.driverTimeoutNs + "ns");
    }

    private int checkTimeouts(long l2) {
        int n2 = 0;
        if (this.timeOfLastServiceNs + Aeron.Configuration.IDLE_SLEEP_NS - l2 < 0L) {
            this.checkServiceInterval(l2);
            this.timeOfLastServiceNs = l2;
            n2 += this.checkLiveness(l2);
            n2 += this.checkLingeringResources(l2);
        }
        return n2;
    }

    private void checkServiceInterval(long l2) {
        if (this.timeOfLastServiceNs + this.interServiceTimeoutNs - l2 < 0L) {
            this.isTerminating = true;
            this.forceCloseResources();
            throw new ConductorServiceTimeoutException("service interval exceeded: timeout=" + this.interServiceTimeoutNs + "ns, interval=" + (l2 - this.timeOfLastServiceNs) + "ns");
        }
    }

    private int checkLiveness(long l2) {
        if (this.timeOfLastKeepAliveNs + this.keepAliveIntervalNs - l2 < 0L) {
            long l3;
            long l4 = this.epochClock.time();
            if (l4 > (l3 = this.driverProxy.timeOfLastDriverKeepaliveMs()) + this.driverTimeoutMs) {
                this.isTerminating = true;
                this.forceCloseResources();
                throw new DriverTimeoutException("MediaDriver (" + this.aeron.context().aeronDirectoryName() + ") keepalive: age=" + (l4 - l3) + "ms > timeout=" + this.driverTimeoutMs + "ms");
            }
            if (null == this.heartbeatTimestamp) {
                int n2 = HeartbeatTimestamp.findCounterIdByRegistrationId(this.countersReader, 11, this.ctx.clientId());
                if (n2 != -1) {
                    this.heartbeatTimestamp = new AtomicCounter(this.counterValuesBuffer, n2);
                    this.heartbeatTimestamp.setOrdered(l4);
                    this.timeOfLastKeepAliveNs = l2;
                }
            } else {
                int n3 = this.heartbeatTimestamp.id();
                if (!HeartbeatTimestamp.isActive(this.countersReader, n3, 11, this.ctx.clientId())) {
                    this.isTerminating = true;
                    this.forceCloseResources();
                    throw new AeronException("unexpected close of heartbeat timestamp counter: " + n3);
                }
                this.heartbeatTimestamp.setOrdered(l4);
                this.timeOfLastKeepAliveNs = l2;
            }
            return 1;
        }
        return 0;
    }

    private int checkLingeringResources(long l2) {
        int n2;
        int n3 = 0;
        for (int i2 = n2 = this.lingeringLogBuffers.size() - 1; i2 >= 0; --i2) {
            LogBuffers logBuffers = this.lingeringLogBuffers.get(i2);
            if (logBuffers.lingerDeadlineNs() - l2 >= 0L) continue;
            ArrayListUtil.fastUnorderedRemove(this.lingeringLogBuffers, i2, n2--);
            CloseHelper.close(this.ctx.errorHandler(), logBuffers);
            ++n3;
        }
        return n3;
    }

    private void forceCloseResources() {
        for (Object e2 : this.resourceByRegIdMap.values()) {
            AutoCloseable autoCloseable;
            if (e2 instanceof Subscription) {
                autoCloseable = (Subscription)e2;
                ((Subscription)autoCloseable).internalClose(-1L);
                continue;
            }
            if (e2 instanceof Publication) {
                autoCloseable = (Publication)e2;
                ((Publication)autoCloseable).internalClose();
                this.releaseLogBuffers(((Publication)autoCloseable).logBuffers(), ((Publication)autoCloseable).originalRegistrationId(), -1L);
                continue;
            }
            if (!(e2 instanceof Counter)) continue;
            autoCloseable = (Counter)e2;
            ((Counter)autoCloseable).internalClose();
            this.notifyUnavailableCounterHandlers(((Counter)autoCloseable).registrationId(), ((AtomicCounter)autoCloseable).id());
        }
        this.resourceByRegIdMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnavailableCounterHandlers(long l2, int n2) {
        for (UnavailableCounterHandler unavailableCounterHandler : this.unavailableCounterHandlerById.values()) {
            this.isInCallback = true;
            try {
                unavailableCounterHandler.onUnavailableCounter(this.countersReader, l2, n2);
            }
            catch (AgentTerminationException agentTerminationException) {
                if (!this.isTerminating) {
                    throw agentTerminationException;
                }
                this.handleError(agentTerminationException);
            }
            catch (Exception exception) {
                this.handleError(exception);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImageUnavailable(UnavailableImageHandler unavailableImageHandler, Image image) {
        this.isInCallback = true;
        try {
            unavailableImageHandler.onUnavailableImage(image);
        }
        catch (AgentTerminationException agentTerminationException) {
            if (!this.isTerminating) {
                throw agentTerminationException;
            }
            this.handleError(agentTerminationException);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        finally {
            this.isInCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCounterAvailable(long l2, int n2, AvailableCounterHandler availableCounterHandler) {
        this.isInCallback = true;
        try {
            availableCounterHandler.onAvailableCounter(this.countersReader, l2, n2);
        }
        catch (AgentTerminationException agentTerminationException) {
            throw agentTerminationException;
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        finally {
            this.isInCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloseHandlers() {
        for (Runnable runnable : this.closeHandlerByIdMap.values()) {
            this.isInCallback = true;
            try {
                runnable.run();
            }
            catch (Exception exception) {
                this.handleError(exception);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    private <T> T resourceOrThrow(long l2, Class<T> clazz) {
        Object object = this.resourceByRegIdMap.get(l2);
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        RegistrationException registrationException = this.asyncExceptionByRegIdMap.remove(l2);
        if (null != registrationException) {
            throw new RegistrationException(registrationException);
        }
        return null;
    }

    private static final class PendingSubscription {
        private final Subscription subscription;

        private PendingSubscription(Subscription subscription) {
            this.subscription = subscription;
        }
    }
}

