/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.SegmentedBar;

public class SegmentedBarSkin<T extends SegmentedBar.Segment>
extends SkinBase<SegmentedBar<T>> {
    private Map<T, Node> segmentNodes = new HashMap<T, Node>();
    private InvalidationListener buildListener = observable -> this.buildSegments();
    private WeakInvalidationListener weakBuildListener = new WeakInvalidationListener(this.buildListener);
    private InvalidationListener layoutListener = observable -> ((SegmentedBar)this.getSkinnable()).requestLayout();
    private WeakInvalidationListener weakLayoutListener = new WeakInvalidationListener(this.layoutListener);
    private PopOver popOver;

    public SegmentedBarSkin(SegmentedBar<T> segmentedBar) {
        super(segmentedBar);
        segmentedBar.segmentViewFactoryProperty().addListener((InvalidationListener)this.weakBuildListener);
        segmentedBar.getSegments().addListener((InvalidationListener)this.weakBuildListener);
        segmentedBar.orientationProperty().addListener((InvalidationListener)this.weakLayoutListener);
        segmentedBar.totalProperty().addListener((InvalidationListener)this.weakBuildListener);
        segmentedBar.orientationProperty().addListener(observable -> {
            if (this.popOver == null) {
                return;
            }
            switch (segmentedBar.getOrientation()) {
                case HORIZONTAL: {
                    this.popOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_CENTER);
                    break;
                }
                case VERTICAL: {
                    this.popOver.setArrowLocation(PopOver.ArrowLocation.RIGHT_CENTER);
                }
            }
        });
        this.buildSegments();
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        OptionalDouble optionalDouble;
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.HORIZONTAL) && (optionalDouble = this.getChildren().stream().mapToDouble(node -> node.prefHeight(-1.0)).max()).isPresent()) {
            return optionalDouble.getAsDouble();
        }
        return ((SegmentedBar)this.getSkinnable()).getPrefHeight();
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        OptionalDouble optionalDouble;
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL) && (optionalDouble = this.getChildren().stream().mapToDouble(node -> node.prefWidth(d2)).max()).isPresent()) {
            return optionalDouble.getAsDouble();
        }
        return ((SegmentedBar)this.getSkinnable()).getPrefWidth();
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            return this.computePrefHeight(d2, d3, d4, d5, d6);
        }
        return 0.0;
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL)) {
            return this.computePrefWidth(d2, d3, d4, d5, d6);
        }
        return 0.0;
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            return this.computePrefHeight(d2, d3, d4, d5, d6);
        }
        return Double.MAX_VALUE;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL)) {
            return this.computePrefWidth(d2, d3, d4, d5, d6);
        }
        return Double.MAX_VALUE;
    }

    private void buildSegments() {
        this.segmentNodes.clear();
        this.getChildren().clear();
        ObservableList observableList = ((SegmentedBar)this.getSkinnable()).getSegments();
        int n2 = observableList.size();
        Callback callback = ((SegmentedBar)this.getSkinnable()).getSegmentViewFactory();
        for (int i2 = 0; i2 < n2; ++i2) {
            SegmentedBar.Segment segment = (SegmentedBar.Segment)observableList.get(i2);
            Node node = (Node)callback.call((Object)segment);
            this.segmentNodes.put(segment, node);
            this.getChildren().add((Object)node);
            node.getStyleClass().add((Object)"segment");
            if (i2 == 0) {
                if (n2 == 1) {
                    node.getStyleClass().add((Object)"only-segment");
                } else {
                    node.getStyleClass().add((Object)"first-segment");
                }
            } else if (i2 == n2 - 1) {
                node.getStyleClass().add((Object)"last-segment");
            } else {
                node.getStyleClass().add((Object)"middle-segment");
            }
            node.setOnMouseEntered(mouseEvent -> this.showPopOver(node, segment));
            node.setOnMouseExited(mouseEvent -> this.hidePopOver());
        }
        ((SegmentedBar)this.getSkinnable()).requestLayout();
    }

    private void showPopOver(Node node, T t2) {
        Callback callback = ((SegmentedBar)this.getSkinnable()).getInfoNodeFactory();
        Node node2 = null;
        if (callback != null) {
            node2 = (Node)callback.call(t2);
        }
        if (node2 != null) {
            if (this.popOver == null) {
                this.popOver = new PopOver();
                this.popOver.setAnimated(false);
                this.popOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_CENTER);
                this.popOver.setDetachable(false);
                this.popOver.setArrowSize(6.0);
                this.popOver.setCornerRadius(3.0);
                this.popOver.setAutoFix(false);
                this.popOver.setAutoHide(true);
            }
            this.popOver.setContentNode(node2);
            this.popOver.show(node, -2.0);
        }
    }

    private void hidePopOver() {
        if (this.popOver != null && this.popOver.isShowing()) {
            this.popOver.hide();
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = ((SegmentedBar)this.getSkinnable()).getTotal();
        ObservableList observableList = ((SegmentedBar)this.getSkinnable()).getSegments();
        int n2 = observableList.size();
        double d7 = d2;
        double d8 = d3 + d5;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d9;
            SegmentedBar.Segment segment = (SegmentedBar.Segment)observableList.get(i2);
            Node node = this.segmentNodes.get(segment);
            double d10 = segment.getValue();
            if (((SegmentedBar)this.getSkinnable()).getOrientation().equals((Object)Orientation.HORIZONTAL)) {
                d9 = d10 / d6 * d4;
                node.resizeRelocate(d7, d3, d9, d5);
                d7 += d9;
                continue;
            }
            d9 = d10 / d6 * d5;
            node.resizeRelocate(d2, d8 - d9, d4, d9);
            d8 -= d9;
        }
    }
}

