/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.skin.NotificationBar;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;

public class NotificationPaneSkin
extends SkinBase<NotificationPane> {
    private NotificationBar notificationBar;
    private Node content;
    private Rectangle clip = new Rectangle();

    public NotificationPaneSkin(final NotificationPane notificationPane) {
        super((Control)notificationPane);
        this.notificationBar = new NotificationBar(){

            @Override
            public void requestContainerLayout() {
                notificationPane.requestLayout();
            }

            @Override
            public String getText() {
                return notificationPane.getText();
            }

            @Override
            public Node getGraphic() {
                return notificationPane.getGraphic();
            }

            @Override
            public ObservableList<Action> getActions() {
                return notificationPane.getActions();
            }

            @Override
            public boolean isShowing() {
                return notificationPane.isShowing();
            }

            @Override
            public boolean isShowFromTop() {
                return notificationPane.isShowFromTop();
            }

            @Override
            public void hide() {
                notificationPane.hide();
            }

            @Override
            public boolean isCloseButtonVisible() {
                return notificationPane.isCloseButtonVisible();
            }

            @Override
            public double getContainerHeight() {
                return notificationPane.getHeight();
            }

            @Override
            public void relocateInParent(double d2, double d3) {
                NotificationPaneSkin.this.notificationBar.relocate(d2, d3);
            }
        };
        notificationPane.setClip((Node)this.clip);
        this.updateContent();
        this.registerChangeListener((ObservableValue)notificationPane.heightProperty(), observableValue -> {
            if (((NotificationPane)this.getSkinnable()).isShowing() && !((NotificationPane)this.getSkinnable()).isShowFromTop()) {
                this.notificationBar.requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)notificationPane.contentProperty(), observableValue -> this.updateContent());
        this.registerChangeListener((ObservableValue)notificationPane.textProperty(), observableValue -> this.notificationBar.label.setText(((NotificationPane)this.getSkinnable()).getText()));
        this.registerChangeListener((ObservableValue)notificationPane.graphicProperty(), observableValue -> this.notificationBar.label.setGraphic(((NotificationPane)this.getSkinnable()).getGraphic()));
        this.registerChangeListener((ObservableValue)notificationPane.showingProperty(), observableValue -> {
            if (((NotificationPane)this.getSkinnable()).isShowing()) {
                this.notificationBar.doShow();
            } else {
                this.notificationBar.doHide();
            }
        });
        this.registerChangeListener((ObservableValue)notificationPane.showFromTopProperty(), observableValue -> {
            if (((NotificationPane)this.getSkinnable()).isShowing()) {
                ((NotificationPane)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)notificationPane.closeButtonVisibleProperty(), observableValue -> this.notificationBar.updatePane());
        ((NotificationPane)this.getSkinnable()).focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue() && this.getChildren().size() > 0) {
                ((Node)this.getChildren().get(0)).requestFocus();
            }
        });
        EventHandler eventHandler = keyEvent -> {
            if (KeyCode.TAB.equals((Object)keyEvent.getCode()) && this.content != null && this.content.isFocused() && keyEvent.isShiftDown()) {
                ImplUtils.focusPreviousSibling((Node)this.getSkinnable());
            }
        };
        ((NotificationPane)this.getSkinnable()).addEventHandler(KeyEvent.KEY_PRESSED, eventHandler);
    }

    private void updateContent() {
        this.content = ((NotificationPane)this.getSkinnable()).getContent();
        if (this.content == null) {
            this.getChildren().setAll((Object[])new Node[]{this.notificationBar});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.content, this.notificationBar});
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.notificationBar.prefHeight(d4);
        this.notificationBar.resize(d4, d6);
        if (this.content != null) {
            this.content.resizeRelocate(d2, d3, d4, d5);
        }
        this.clip.setX(d2);
        this.clip.setY(d3);
        this.clip.setWidth(d4);
        this.clip.setHeight(d5);
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.minWidth(d2);
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.minHeight(d2);
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.prefWidth(d2);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.prefHeight(d2);
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.maxWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.content == null ? 0.0 : this.content.maxHeight(d2);
    }
}

