/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.ListActionView;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;

public class ListActionViewSkin<T>
extends SkinBase<ListActionView<T>> {
    private BorderPane borderPane = new BorderPane();
    private ListView<T> listView;

    public ListActionViewSkin(ListActionView<T> listActionView) {
        super(listActionView);
        this.borderPane.getStyleClass().add((Object)"container");
        this.listView = this.createListView();
        this.listView.cellFactoryProperty().bind(((ListActionView)this.getSkinnable()).cellFactoryProperty());
        Bindings.bindContentBidirectional((ObservableList)this.listView.getItems(), ((ListActionView)this.getSkinnable()).getItems());
        listActionView.getActions().addListener(observable -> this.update());
        listActionView.sideProperty().addListener(observable -> this.update());
        this.update();
        this.getChildren().add((Object)this.borderPane);
    }

    private void update() {
        this.borderPane.getChildren().clear();
        this.borderPane.setCenter(this.listView);
        if (!((ListActionView)this.getSkinnable()).getActions().isEmpty()) {
            Side side = ((ListActionView)this.getSkinnable()).getSide();
            switch (side) {
                case TOP: {
                    this.borderPane.setTop((Node)this.createButtonBar(Orientation.HORIZONTAL, new String[0]));
                    break;
                }
                case RIGHT: {
                    this.borderPane.setRight((Node)this.createButtonBar(Orientation.VERTICAL, "right"));
                    break;
                }
                case BOTTOM: {
                    this.borderPane.setBottom((Node)this.createButtonBar(Orientation.HORIZONTAL, "bottom"));
                    break;
                }
                case LEFT: {
                    this.borderPane.setLeft((Node)this.createButtonBar(Orientation.VERTICAL, new String[0]));
                }
            }
        }
    }

    private ToolBar createButtonBar(Orientation orientation, String ... stringArray) {
        ToolBar toolBar = new ToolBar();
        toolBar.setOrientation(orientation);
        toolBar.getStyleClass().addAll((Object[])stringArray);
        toolBar.getItems().addAll(this.createButtonsFromActions());
        return toolBar;
    }

    private ObservableList<Node> createButtonsFromActions() {
        return ((ListActionView)this.getSkinnable()).getActions().stream().peek(this::initializeListAction).map(this::createActionNode).collect(Collectors.toCollection(FXCollections::observableArrayList));
    }

    private void initializeListAction(Action action) {
        if (action instanceof ListActionView.ListAction) {
            ((ListActionView.ListAction)action).initialize(this.listView);
        }
    }

    private Node createActionNode(Action action) {
        if (action == ActionUtils.ACTION_SEPARATOR) {
            return new Separator();
        }
        if (action == ActionUtils.ACTION_SPAN) {
            Pane pane = new Pane();
            HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
            return pane;
        }
        return this.createActionButton(action);
    }

    private Button createActionButton(Action action) {
        Button button = ActionUtils.createButton(action);
        button.setMaxWidth(Double.MAX_VALUE);
        if (action.getAccelerator() != null) {
            ((ListActionView)this.getSkinnable()).getScene().getAccelerators().put((Object)action.getAccelerator(), () -> ((Button)button).fire());
        }
        return button;
    }

    protected ListView<T> createListView() {
        ListView listView = new ListView();
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        return listView;
    }
}

