/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.annotation;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import com.sun.xml.bind.v2.model.annotation.Messages;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class RuntimeInlineAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private final Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache = new HashMap<Class<? extends Annotation>, Map<Package, Annotation>>();

    @Override
    public <A extends Annotation> A getFieldAnnotation(Class<A> clazz, Field field, Locatable locatable) {
        return LocatableAnnotation.create(field.getAnnotation(clazz), locatable);
    }

    @Override
    public boolean hasFieldAnnotation(Class<? extends Annotation> clazz, Field field) {
        return field.isAnnotationPresent(clazz);
    }

    @Override
    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    @Override
    public Annotation[] getAllFieldAnnotations(Field field, Locatable locatable) {
        Annotation[] annotationArray = field.getAnnotations();
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            annotationArray[i2] = LocatableAnnotation.create(annotationArray[i2], locatable);
        }
        return annotationArray;
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Class<A> clazz, Method method, Locatable locatable) {
        return LocatableAnnotation.create(method.getAnnotation(clazz), locatable);
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> clazz, Method method) {
        return method.isAnnotationPresent(clazz);
    }

    @Override
    public Annotation[] getAllMethodAnnotations(Method method, Locatable locatable) {
        Annotation[] annotationArray = method.getAnnotations();
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            annotationArray[i2] = LocatableAnnotation.create(annotationArray[i2], locatable);
        }
        return annotationArray;
    }

    @Override
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> clazz, Method method, int n2, Locatable locatable) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = method.getParameterAnnotations()[n2]) {
            if (annotation.annotationType() != clazz) continue;
            return (A)LocatableAnnotation.create(annotation, locatable);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<A> clazz, Class clazz2, Locatable locatable) {
        return LocatableAnnotation.create(clazz2.getAnnotation(clazz), locatable);
    }

    @Override
    public <A extends Annotation> A getPackageAnnotation(Class<A> clazz, Class clazz2, Locatable locatable) {
        Package package_ = clazz2.getPackage();
        if (package_ == null) {
            return null;
        }
        Map<Package, Annotation> map = this.packageCache.get(clazz);
        if (map == null) {
            map = new HashMap<Package, Annotation>();
            this.packageCache.put(clazz, map);
        }
        if (map.containsKey(package_)) {
            return (A)map.get(package_);
        }
        A a2 = LocatableAnnotation.create(package_.getAnnotation(clazz), locatable);
        map.put(package_, (Annotation)a2);
        return a2;
    }

    @Override
    public Class getClassValue(Annotation annotation, String string) {
        try {
            return (Class)annotation.annotationType().getMethod(string, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(Messages.CLASS_NOT_FOUND.format(annotation.annotationType(), invocationTargetException.getMessage()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    public Class[] getClassArrayValue(Annotation annotation, String string) {
        try {
            return (Class[])annotation.annotationType().getMethod(string, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    @Override
    protected String fullName(Method method) {
        return method.getDeclaringClass().getName() + '#' + method.getName();
    }
}

