/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXSnackbar
extends Group {
    private static final String DEFAULT_STYLE_CLASS = "jfx-snackbar";
    private Pane snackbarContainer;
    private ChangeListener<? super Number> sizeListener = (observableValue, number, number2) -> this.refreshPopup();
    private WeakChangeListener<? super Number> weakSizeListener = new WeakChangeListener(this.sizeListener);
    private AtomicBoolean processingQueue = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<SnackbarEvent> eventQueue = new ConcurrentLinkedQueue();
    private ConcurrentHashMap.KeySetView<Object, Boolean> eventsSet = ConcurrentHashMap.newKeySet();
    private Interpolator easeInterpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    private Pane content;
    private PseudoClass activePseudoClass = null;
    private PauseTransition pauseTransition;
    private Timeline openAnimation = null;
    private SnackbarEvent currentEvent = null;

    public JFXSnackbar() {
        this(null);
    }

    public JFXSnackbar(Pane pane) {
        this.initialize();
        this.content = new StackPane();
        this.content.getStyleClass().add((Object)"jfx-snackbar-content");
        this.getChildren().add((Object)this.content);
        this.setManaged(false);
        this.setVisible(false);
        this.registerSnackbarContainer(pane);
        this.layoutBoundsProperty().addListener((observableValue, bounds, bounds2) -> this.refreshPopup());
        this.addEventHandler(SnackbarEvent.SNACKBAR, snackbarEvent -> this.enqueue((SnackbarEvent)snackbarEvent));
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Pane getPopupContainer() {
        return this.snackbarContainer;
    }

    public void setPrefWidth(double d2) {
        this.content.setPrefWidth(d2);
    }

    public double getPrefWidth() {
        return this.content.getPrefWidth();
    }

    public void registerSnackbarContainer(Pane pane) {
        if (pane != null) {
            if (this.snackbarContainer != null) {
                throw new IllegalArgumentException("Snackbar Container already set");
            }
            this.snackbarContainer = pane;
            this.snackbarContainer.getChildren().add((Object)this);
            this.snackbarContainer.heightProperty().addListener(this.weakSizeListener);
            this.snackbarContainer.widthProperty().addListener(this.weakSizeListener);
        }
    }

    public void unregisterSnackbarContainer(Pane pane) {
        if (pane != null) {
            if (this.snackbarContainer == null) {
                throw new IllegalArgumentException("Snackbar Container not set");
            }
            this.snackbarContainer.getChildren().remove((Object)this);
            this.snackbarContainer.heightProperty().removeListener(this.weakSizeListener);
            this.snackbarContainer.widthProperty().removeListener(this.weakSizeListener);
            this.snackbarContainer = null;
        }
    }

    private void show(SnackbarEvent snackbarEvent) {
        this.content.getChildren().setAll((Object[])new Node[]{snackbarEvent.getContent()});
        this.openAnimation = this.getTimeline(snackbarEvent.getTimeout());
        if (snackbarEvent.getPseudoClass() != null) {
            this.activePseudoClass = snackbarEvent.getPseudoClass();
            this.content.pseudoClassStateChanged(this.activePseudoClass, true);
        }
        this.openAnimation.play();
    }

    private Timeline getTimeline(Duration duration) {
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.toBack(), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.translateYProperty(), (Object)this.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), actionEvent -> this.toFront(), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, this.easeInterpolator)})});
        timeline.setCycleCount(1);
        PauseTransition pauseTransition = this.pauseTransition = Duration.INDEFINITE.equals((Object)duration) ? null : new PauseTransition(duration);
        if (this.pauseTransition != null) {
            timeline.setOnFinished(actionEvent2 -> {
                this.pauseTransition.setOnFinished(actionEvent -> {
                    this.pauseTransition = null;
                    this.eventsSet.remove((Object)this.currentEvent);
                    this.currentEvent = this.eventQueue.peek();
                    this.close();
                });
                this.pauseTransition.play();
            });
        }
        return timeline;
    }

    public void close() {
        if (this.openAnimation != null) {
            this.openAnimation.stop();
        }
        if (this.isVisible()) {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.toFront(), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)290.0), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), actionEvent -> this.toBack(), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.translateYProperty(), (Object)this.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)0, this.easeInterpolator)})});
            timeline.setCycleCount(1);
            timeline.setOnFinished(actionEvent -> {
                this.resetPseudoClass();
                this.processSnackbar();
            });
            timeline.play();
        }
    }

    public SnackbarEvent getCurrentEvent() {
        return this.currentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(SnackbarEvent snackbarEvent) {
        JFXSnackbar jFXSnackbar = this;
        synchronized (jFXSnackbar) {
            if (!this.eventsSet.contains((Object)snackbarEvent)) {
                this.eventsSet.add((Object)snackbarEvent);
                this.eventQueue.offer(snackbarEvent);
            } else if (this.currentEvent == snackbarEvent && this.pauseTransition != null) {
                this.pauseTransition.playFromStart();
            }
        }
        if (this.processingQueue.compareAndSet(false, true)) {
            Platform.runLater(() -> {
                this.currentEvent = this.eventQueue.poll();
                if (this.currentEvent != null) {
                    this.show(this.currentEvent);
                }
            });
        }
    }

    private void resetPseudoClass() {
        if (this.activePseudoClass != null) {
            this.content.pseudoClassStateChanged(this.activePseudoClass, false);
            this.activePseudoClass = null;
        }
    }

    private void processSnackbar() {
        this.currentEvent = this.eventQueue.poll();
        if (this.currentEvent != null) {
            this.eventsSet.remove((Object)this.currentEvent);
            this.show(this.currentEvent);
        } else {
            this.processingQueue.getAndSet(false);
        }
    }

    private void refreshPopup() {
        if (this.snackbarContainer == null) {
            return;
        }
        Bounds bounds = this.getLayoutBounds();
        double d2 = Math.ceil(this.snackbarContainer.getWidth() / 2.0) - Math.ceil(bounds.getWidth() / 2.0);
        double d3 = this.snackbarContainer.getHeight() - bounds.getHeight();
        this.setLayoutX(d2);
        this.setLayoutY(d3);
    }

    public static class SnackbarEvent
    extends Event {
        public static final EventType<SnackbarEvent> SNACKBAR = new EventType(Event.ANY, "SNACKBAR");
        public static Duration DEFAULT_DURATION = Duration.seconds((double)1.5);
        private final Node content;
        private final PseudoClass pseudoClass;
        private final Duration timeout;

        public SnackbarEvent(Node node) {
            this(node, DEFAULT_DURATION, null);
        }

        public SnackbarEvent(Node node, PseudoClass pseudoClass) {
            this(node, DEFAULT_DURATION, pseudoClass);
        }

        public SnackbarEvent(Node node, Duration duration) {
            this(node, duration, null);
        }

        public SnackbarEvent(Node node, Duration duration, PseudoClass pseudoClass) {
            super(SNACKBAR);
            this.content = node;
            this.pseudoClass = pseudoClass;
            this.timeout = duration;
        }

        public Node getContent() {
            return this.content;
        }

        public PseudoClass getPseudoClass() {
            return this.pseudoClass;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public EventType<? extends SnackbarEvent> getEventType() {
            return super.getEventType();
        }

        public boolean isPersistent() {
            return Duration.INDEFINITE.equals((Object)this.getTimeout());
        }
    }
}

