/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXRadioButtonSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class JFXRadioButton
extends RadioButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-radio-button";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-radio-button.css").toExternalForm();
    private StyleableObjectProperty<Color> selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "selectedColor", (Object)Color.valueOf((String)"#0F9D58"));
    private StyleableObjectProperty<Color> unSelectedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)this, "unSelectedColor", (Object)Color.valueOf((String)"#5A5A5A"));
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$200(), (Object)this, "disableVisualFocus", false);
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$300(), (Object)this, "disableAnimation", false);

    public JFXRadioButton(String string) {
        super(string);
        this.initialize();
    }

    public JFXRadioButton() {
        this.initialize();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length && i2 < 15; ++i2) {
            if (!stackTraceElementArray[i2].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("RadioButton");
            break;
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXRadioButtonSkin(this);
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? Color.rgb((int)0, (int)0, (int)0, (double)0.2) : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color color) {
        this.selectedColorProperty().set((Object)color);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? Color.TRANSPARENT : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color color) {
        this.unSelectedColorProperty().set((Object)color);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean bl2) {
        this.disableVisualFocusProperty().set(bl2.booleanValue());
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean bl2) {
        this.disableAnimationProperty().set(bl2.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXRadioButton.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXRadioButton, Color> SELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-selected-color", ColorConverter.getInstance(), Color.valueOf((String)"#0F9D58")){

            public boolean isSettable(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.selectedColor == null || !jFXRadioButton.selectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Color> UNSELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-unselected-color", ColorConverter.getInstance(), Color.valueOf((String)"#5A5A5A")){

            public boolean isSettable(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.unSelectedColor == null || !jFXRadioButton.unSelectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.unSelectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXRadioButton, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.disableVisualFocus == null || !jFXRadioButton.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.disableVisualFocusProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXRadioButton, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.disableAnimation == null || !jFXRadioButton.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXRadioButton jFXRadioButton) {
                return jFXRadioButton.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNSELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return DISABLE_VISUAL_FOCUS;
        }

        static /* synthetic */ CssMetaData access$300() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList arrayList = new ArrayList(RadioButton.getClassCssMetaData());
            Collections.addAll(arrayList, SELECTED_COLOR, UNSELECTED_COLOR, DISABLE_VISUAL_FOCUS, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

