/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.BiFunction;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class JFXNodesList
extends VBox {
    private static final String ALIGN_NODE_CONSTRAINT = "align-node";
    private final HashMap<Node, BiFunction<Boolean, Duration, Collection<KeyFrame>>> animationsMap = new HashMap();
    private boolean expanded = false;
    private final Timeline animateTimeline = new Timeline();
    private boolean performingLayout = false;

    private static void setConstraint(Node node, Object object, Object object2) {
        if (object2 == null) {
            node.getProperties().remove(object);
        } else {
            node.getProperties().put(object, object2);
        }
        if (node.getParent() != null) {
            node.getParent().requestLayout();
        }
    }

    private static Object getConstraint(Node node, Object object) {
        Object object2;
        if (node.hasProperties() && (object2 = node.getProperties().get(object)) != null) {
            return object2;
        }
        return null;
    }

    public static void alignNodeToChild(Node node, Node node2) {
        JFXNodesList.setConstraint(node, ALIGN_NODE_CONSTRAINT, node2);
    }

    public static Node getAlignNodeToChild(Node node) {
        return (Node)JFXNodesList.getConstraint(node, ALIGN_NODE_CONSTRAINT);
    }

    public JFXNodesList() {
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-nodes-list");
        this.setAlignment(Pos.TOP_CENTER);
    }

    public void addAnimatedNode(Region region) {
        this.addAnimatedNode(region, null, true);
    }

    public void addAnimatedNode(Region region, boolean bl2) {
        this.addAnimatedNode(region, null, bl2);
    }

    public void addAnimatedNode(Region region, BiFunction<Boolean, Duration, Collection<KeyFrame>> biFunction) {
        this.addAnimatedNode(region, biFunction, true);
    }

    public void addAnimatedNode(Region region, BiFunction<Boolean, Duration, Collection<KeyFrame>> biFunction, boolean bl2) {
        if (region instanceof JFXNodesList) {
            StackPane stackPane = new StackPane(new Node[]{region});
            stackPane.setPickOnBounds(false);
            this.addAnimatedNode((Region)stackPane, biFunction, bl2);
            return;
        }
        this.initChild((Node)region, this.getChildren().size(), biFunction, bl2);
        this.getChildren().add((Object)region);
    }

    private void initChild(Node node, int n2, BiFunction<Boolean, Duration, Collection<KeyFrame>> biFunction, boolean bl3) {
        if (n2 > 0) {
            this.initNode(node);
            node.setVisible(false);
        } else {
            if (bl3) {
                if (node instanceof Button) {
                    node.addEventHandler(ActionEvent.ACTION, actionEvent -> this.animateList());
                } else {
                    node.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.animateList());
                }
            }
            node.getStyleClass().add((Object)"trigger-node");
            node.setVisible(true);
        }
        if (biFunction == null && n2 != 0) {
            biFunction = this.initDefaultAnimation(node);
        } else if (biFunction == null && n2 == 0) {
            biFunction = (bl2, duration) -> new ArrayList();
        }
        this.animationsMap.put(node, biFunction);
    }

    protected double computePrefWidth(double d2) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefWidth(d2);
        }
        return super.computePrefWidth(d2);
    }

    protected double computePrefHeight(double d2) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefHeight(d2);
        }
        return super.computePrefHeight(d2);
    }

    protected double computeMinHeight(double d2) {
        return this.computePrefHeight(d2);
    }

    protected double computeMinWidth(double d2) {
        return this.computePrefWidth(d2);
    }

    protected double computeMaxHeight(double d2) {
        return this.computePrefHeight(d2);
    }

    protected double computeMaxWidth(double d2) {
        return this.computePrefWidth(d2);
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        ObservableList observableList = this.getChildren();
        Insets insets = this.getInsets();
        double d2 = this.getWidth();
        double d3 = this.getRotate();
        double d4 = this.getHeight();
        double d5 = this.snapSpace(insets.getLeft());
        double d6 = this.snapSpace(insets.getRight());
        double d7 = this.snapSpace(this.getSpacing());
        boolean bl2 = this.isFillWidth();
        double d8 = d2 - d5 - d6;
        Pos pos = this.getAlignment();
        pos = pos == null ? Pos.TOP_CENTER : pos;
        HPos hPos = pos.getHpos();
        VPos vPos = pos.getVpos();
        double d9 = 0.0;
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Insets insets2;
            Node node = (Node)observableList.get(i2);
            node.autosize();
            node.setRotate(d3 % 180.0 == 0.0 ? d3 : -d3);
            if (!this.animationsMap.containsKey(node)) {
                if (node instanceof JFXNodesList) {
                    StackPane stackPane = new StackPane(new Node[]{node});
                    stackPane.setPickOnBounds(false);
                    this.getChildren().set(i2, (Object)stackPane);
                }
                this.initChild(node, i2, null, true);
            }
            double d10 = 0.0;
            double d11 = node.getLayoutBounds().getWidth();
            double d12 = node.getLayoutBounds().getHeight();
            if (d11 > d2) {
                switch (hPos) {
                    case CENTER: {
                        d10 = this.snapPosition(d8 - d11) / 2.0;
                    }
                }
                insets2 = JFXNodesList.getAlignNodeToChild(node);
                if (insets2 != null && node instanceof Parent) {
                    ((Parent)node).layout();
                    double d13 = insets2.getLayoutBounds().getWidth();
                    double d14 = insets2.getLayoutX();
                    d13 = d11 / 2.0 > d14 + d13 ? -(d11 / 2.0 - (d13 / 2.0 + d14)) : d13 / 2.0 + d14 - d11 / 2.0;
                    node.setTranslateX(-d13 * Math.cos(Math.toRadians(d3)));
                    node.setTranslateY(d13 * Math.cos(Math.toRadians(90.0 - d3)));
                }
            } else {
                d11 = d8;
            }
            insets2 = JFXNodesList.getMargin((Node)node);
            if (insets2 != null) {
                d11 += insets2.getLeft() + insets2.getRight();
                d12 += insets2.getTop() + insets2.getRight();
            }
            this.layoutInArea(node, d10, d9, d11, d12, 0.0, insets2, bl2, true, hPos, vPos);
            d9 += node.getLayoutBounds().getHeight() + d7;
            if (insets2 != null) {
                d9 += insets2.getTop() + insets2.getBottom();
            }
            d9 = this.snapPosition(d9);
        }
        this.performingLayout = false;
    }

    public void animateList() {
        boolean bl2 = this.expanded = !this.expanded;
        if (this.animateTimeline.getStatus() == Animation.Status.RUNNING) {
            this.animateTimeline.stop();
        }
        this.animateTimeline.getKeyFrames().clear();
        this.createAnimation(this.expanded, this.animateTimeline);
        this.animateTimeline.play();
    }

    public void animateList(boolean bl2) {
        if (this.expanded && !bl2 || !this.expanded && bl2) {
            this.animateList();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Animation getListAnimation(boolean bl2) {
        Timeline timeline = new Timeline();
        this.createAnimation(bl2, timeline);
        return timeline;
    }

    private void createAnimation(boolean bl2, Timeline timeline) {
        ObservableList observableList = this.getChildren();
        double d2 = 160.0 / (double)observableList.size();
        if (bl2) {
            for (Node node : observableList) {
                node.setVisible(true);
            }
        }
        for (int i2 = 1; i2 < observableList.size(); ++i2) {
            Node node;
            node = (Node)observableList.get(i2);
            Collection<KeyFrame> collection = this.animationsMap.get(node).apply(bl2, Duration.millis((double)((double)i2 * d2)));
            timeline.getKeyFrames().addAll(collection);
        }
        Collection<KeyFrame> collection = this.animationsMap.get(observableList.get(0)).apply(bl2, Duration.millis((double)160.0));
        timeline.getKeyFrames().addAll(collection);
        if (!bl2) {
            timeline.setOnFinished(actionEvent -> {
                for (int i2 = 1; i2 < observableList.size(); ++i2) {
                    ((Node)observableList.get(i2)).setVisible(false);
                }
            });
        } else {
            timeline.setOnFinished(null);
        }
    }

    private BiFunction<Boolean, Duration, Collection<KeyFrame>> initDefaultAnimation(Node node) {
        return (bl2, duration) -> {
            ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
            arrayList.add(new KeyFrame(duration, actionEvent -> {
                node.setScaleX(bl2 != false ? 1.0 : 0.0);
                node.setScaleY(bl2 != false ? 1.0 : 0.0);
            }, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)(bl2 != false ? 1 : 0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)node.scaleYProperty(), (Object)(bl2 != false ? 1 : 0), Interpolator.EASE_BOTH)}));
            return arrayList;
        };
    }

    protected void initNode(Node node) {
        node.setScaleX(0.0);
        node.setScaleY(0.0);
        node.getStyleClass().add((Object)"sub-node");
    }
}

