/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.svg.SVGGlyph;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.geometry.BoundingBox;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXDecorator
extends VBox {
    private Stage primaryStage;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double newX;
    private double newY;
    private double initX;
    private double initY;
    private double initWidth = -1.0;
    private double initHeight = -1.0;
    private double initStageX = -1.0;
    private double initStageY = -1.0;
    private boolean allowMove = false;
    private boolean isDragging = false;
    private Timeline windowDecoratorAnimation;
    private StackPane contentPlaceHolder = new StackPane();
    private HBox buttonsContainer;
    private ObjectProperty<Runnable> onCloseButtonAction = new SimpleObjectProperty(() -> this.primaryStage.fireEvent((Event)new WindowEvent((Window)this.primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST)));
    private BooleanProperty customMaximize = new SimpleBooleanProperty(false);
    private boolean maximized = false;
    private BoundingBox originalBox;
    private BoundingBox maximizedBox;
    protected JFXButton btnMax;
    protected JFXButton btnFull;
    protected JFXButton btnClose;
    protected JFXButton btnMin;
    protected StringProperty title = new SimpleStringProperty();
    protected Text text;
    protected Node graphic;
    protected HBox graphicContainer;

    public JFXDecorator(Stage stage, Node node) {
        this(stage, node, true, true, true);
    }

    public JFXDecorator(Stage stage, Node node, boolean bl4, boolean bl5, boolean bl6) {
        this.primaryStage = stage;
        this.primaryStage.initStyle(StageStyle.UNDECORATED);
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-decorator");
        this.initializeButtons();
        this.initializeContainers(node, bl4, bl5, bl6);
        this.primaryStage.fullScreenProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.contentPlaceHolder.getStyleClass().remove((Object)"resize-border");
                this.contentPlaceHolder.borderProperty().unbind();
                this.contentPlaceHolder.setBorder(Border.EMPTY);
                if (this.windowDecoratorAnimation != null) {
                    this.windowDecoratorAnimation.stop();
                }
                this.windowDecoratorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(-this.buttonsContainer.getHeight()), Interpolator.EASE_BOTH)})});
                this.windowDecoratorAnimation.setOnFinished(actionEvent -> {
                    this.getChildren().remove((Object)this.buttonsContainer);
                    this.setTranslateY(0.0);
                });
                this.windowDecoratorAnimation.play();
            } else {
                if (this.windowDecoratorAnimation != null) {
                    if (this.windowDecoratorAnimation.getStatus() == Animation.Status.RUNNING) {
                        this.windowDecoratorAnimation.stop();
                    } else {
                        this.getChildren().add(0, (Object)this.buttonsContainer);
                    }
                }
                this.setTranslateY(-this.buttonsContainer.getHeight());
                this.windowDecoratorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                this.windowDecoratorAnimation.setOnFinished(actionEvent -> {
                    this.contentPlaceHolder.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}));
                    this.contentPlaceHolder.getStyleClass().add((Object)"resize-border");
                });
                this.windowDecoratorAnimation.play();
            }
        });
        this.contentPlaceHolder.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.updateInitMouseValues((MouseEvent)mouseEvent));
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.updateInitMouseValues((MouseEvent)mouseEvent));
        this.addEventFilter(MouseEvent.MOUSE_MOVED, mouseEvent -> this.showDragCursorOnBorders((MouseEvent)mouseEvent));
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.isDragging = false;
        });
        this.setOnMouseDragged(mouseEvent -> this.handleDragEventOnDecoratorPane((MouseEvent)mouseEvent));
    }

    private void initializeButtons() {
        SVGGlyph sVGGlyph = new SVGGlyph(0, "FULLSCREEN", "M598 214h212v212h-84v-128h-128v-84zM726 726v-128h84v212h-212v-84h128zM214 426v-212h212v84h-128v128h-84zM298 598v128h128v84h-212v-212h84z", (Paint)Color.WHITE);
        sVGGlyph.setSize(16.0, 16.0);
        SVGGlyph sVGGlyph2 = new SVGGlyph(0, "MINUS", "M804.571 420.571v109.714q0 22.857-16 38.857t-38.857 16h-694.857q-22.857 0-38.857-16t-16-38.857v-109.714q0-22.857 16-38.857t38.857-16h694.857q22.857 0 38.857 16t16 38.857z", (Paint)Color.WHITE);
        sVGGlyph2.setSize(12.0, 2.0);
        sVGGlyph2.setTranslateY(4.0);
        SVGGlyph sVGGlyph3 = new SVGGlyph(0, "RESIZE_MAX", "M726 810v-596h-428v596h428zM726 44q34 0 59 25t25 59v768q0 34-25 60t-59 26h-428q-34 0-59-26t-25-60v-768q0-34 25-60t59-26z", (Paint)Color.WHITE);
        sVGGlyph3.setSize(12.0, 12.0);
        SVGGlyph sVGGlyph4 = new SVGGlyph(0, "RESIZE_MIN", "M80.842 943.158v-377.264h565.894v377.264h-565.894zM0 404.21v619.79h727.578v-619.79h-727.578zM377.264 161.684h565.894v377.264h-134.736v80.842h215.578v-619.79h-727.578v323.37h80.842v-161.686z", (Paint)Color.WHITE);
        sVGGlyph4.setSize(12.0, 12.0);
        SVGGlyph sVGGlyph5 = new SVGGlyph(0, "CLOSE", "M810 274l-238 238 238 238-60 60-238-238-238 238-60-60 238-238-238-238 60-60 238 238 238-238z", (Paint)Color.WHITE);
        sVGGlyph5.setSize(12.0, 12.0);
        this.btnFull = new JFXButton();
        this.btnFull.getStyleClass().add((Object)"jfx-decorator-button");
        this.btnFull.setCursor(Cursor.HAND);
        this.btnFull.setOnAction(actionEvent -> this.primaryStage.setFullScreen(!this.primaryStage.isFullScreen()));
        this.btnFull.setGraphic((Node)sVGGlyph);
        this.btnFull.setTranslateX(-30.0);
        this.btnFull.setRipplerFill((Paint)Color.WHITE);
        this.btnClose = new JFXButton();
        this.btnClose.getStyleClass().add((Object)"jfx-decorator-button");
        this.btnClose.setCursor(Cursor.HAND);
        this.btnClose.setOnAction(actionEvent -> ((Runnable)this.onCloseButtonAction.get()).run());
        this.btnClose.setGraphic((Node)sVGGlyph5);
        this.btnClose.setRipplerFill((Paint)Color.WHITE);
        this.btnMin = new JFXButton();
        this.btnMin.getStyleClass().add((Object)"jfx-decorator-button");
        this.btnMin.setCursor(Cursor.HAND);
        this.btnMin.setOnAction(actionEvent -> this.primaryStage.setIconified(true));
        this.btnMin.setGraphic((Node)sVGGlyph2);
        this.btnMin.setRipplerFill((Paint)Color.WHITE);
        this.btnMax = new JFXButton();
        this.btnMax.getStyleClass().add((Object)"jfx-decorator-button");
        this.btnMax.setCursor(Cursor.HAND);
        this.btnMax.setRipplerFill((Paint)Color.WHITE);
        this.btnMax.setOnAction(actionEvent -> this.maximize(sVGGlyph4, sVGGlyph3));
        this.btnMax.setGraphic((Node)sVGGlyph3);
    }

    private void maximize(SVGGlyph sVGGlyph, SVGGlyph sVGGlyph2) {
        if (!this.isCustomMaximize()) {
            this.primaryStage.setMaximized(!this.primaryStage.isMaximized());
            this.maximized = this.primaryStage.isMaximized();
            if (this.primaryStage.isMaximized()) {
                this.btnMax.setGraphic((Node)sVGGlyph);
                this.btnMax.setTooltip(new Tooltip("Restore Down"));
            } else {
                this.btnMax.setGraphic((Node)sVGGlyph2);
                this.btnMax.setTooltip(new Tooltip("Maximize"));
            }
        } else {
            if (!this.maximized) {
                this.originalBox = new BoundingBox(this.primaryStage.getX(), this.primaryStage.getY(), this.primaryStage.getWidth(), this.primaryStage.getHeight());
                Screen screen = (Screen)Screen.getScreensForRectangle((double)this.primaryStage.getX(), (double)this.primaryStage.getY(), (double)this.primaryStage.getWidth(), (double)this.primaryStage.getHeight()).get(0);
                Rectangle2D rectangle2D = screen.getVisualBounds();
                this.maximizedBox = new BoundingBox(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                this.primaryStage.setX(this.maximizedBox.getMinX());
                this.primaryStage.setY(this.maximizedBox.getMinY());
                this.primaryStage.setWidth(this.maximizedBox.getWidth());
                this.primaryStage.setHeight(this.maximizedBox.getHeight());
                this.btnMax.setGraphic((Node)sVGGlyph);
                this.btnMax.setTooltip(new Tooltip("Restore Down"));
            } else {
                this.primaryStage.setX(this.originalBox.getMinX());
                this.primaryStage.setY(this.originalBox.getMinY());
                this.primaryStage.setWidth(this.originalBox.getWidth());
                this.primaryStage.setHeight(this.originalBox.getHeight());
                this.originalBox = null;
                this.btnMax.setGraphic((Node)sVGGlyph2);
                this.btnMax.setTooltip(new Tooltip("Maximize"));
            }
            this.maximized = !this.maximized;
        }
    }

    private void initializeContainers(Node node, boolean bl2, boolean bl3, boolean bl4) {
        this.buttonsContainer = new HBox();
        this.buttonsContainer.getStyleClass().add((Object)"jfx-decorator-buttons-container");
        this.buttonsContainer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.buttonsContainer.setPadding(new Insets(4.0));
        this.buttonsContainer.setAlignment(Pos.CENTER_RIGHT);
        ArrayList<JFXButton> arrayList = new ArrayList<JFXButton>();
        if (bl2) {
            arrayList.add(this.btnFull);
        }
        if (bl4) {
            arrayList.add(this.btnMin);
        }
        if (bl3) {
            arrayList.add(this.btnMax);
            this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (mouseEvent.getClickCount() == 2) {
                    this.btnMax.fire();
                }
            });
        }
        arrayList.add(this.btnClose);
        this.text = new Text();
        this.text.getStyleClass().addAll((Object[])new String[]{"jfx-decorator-text", "title", "jfx-decorator-title"});
        this.text.setFill((Paint)Color.WHITE);
        this.text.textProperty().bind((ObservableValue)this.title);
        this.title.bind((ObservableValue)this.primaryStage.titleProperty());
        this.graphicContainer = new HBox();
        this.graphicContainer.setPickOnBounds(false);
        this.graphicContainer.setAlignment(Pos.CENTER_LEFT);
        this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.text});
        HBox hBox = new HBox(new Node[]{this.graphicContainer, this.text});
        hBox.getStyleClass().add((Object)"jfx-decorator-title-container");
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setPickOnBounds(false);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.graphicContainer, (Insets)new Insets(0.0, 8.0, 0.0, 8.0));
        this.buttonsContainer.getChildren().setAll((Object[])new Node[]{hBox});
        this.buttonsContainer.getChildren().addAll(arrayList);
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEvent -> {
            this.allowMove = true;
        });
        this.buttonsContainer.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEvent -> {
            if (!this.isDragging) {
                this.allowMove = false;
            }
        });
        this.buttonsContainer.setMinWidth(180.0);
        this.contentPlaceHolder.getStyleClass().add((Object)"jfx-decorator-content-container");
        this.contentPlaceHolder.setMinSize(0.0, 0.0);
        StackPane stackPane = new StackPane(new Node[]{node});
        this.contentPlaceHolder.getChildren().add((Object)stackPane);
        ((Region)node).setMinSize(0.0, 0.0);
        VBox.setVgrow((Node)this.contentPlaceHolder, (Priority)Priority.ALWAYS);
        this.contentPlaceHolder.getStyleClass().add((Object)"resize-border");
        this.contentPlaceHolder.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}));
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)stackPane.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)stackPane.heightProperty());
        stackPane.setClip((Node)rectangle);
        this.getChildren().addAll((Object[])new Node[]{this.buttonsContainer, this.contentPlaceHolder});
    }

    private void showDragCursorOnBorders(MouseEvent mouseEvent) {
        if (this.primaryStage.isMaximized() || this.primaryStage.isFullScreen() || this.maximized) {
            this.setCursor(Cursor.DEFAULT);
            return;
        }
        if (!this.primaryStage.isResizable()) {
            return;
        }
        double d2 = mouseEvent.getX();
        double d3 = mouseEvent.getY();
        if (this.contentPlaceHolder.getBorder() != null && this.contentPlaceHolder.getBorder().getStrokes().size() > 0) {
            double d4 = this.contentPlaceHolder.snappedLeftInset();
            if (this.isRightEdge(d2)) {
                if (d3 < d4) {
                    this.setCursor(Cursor.NE_RESIZE);
                } else if (d3 > this.getHeight() - d4) {
                    this.setCursor(Cursor.SE_RESIZE);
                } else {
                    this.setCursor(Cursor.E_RESIZE);
                }
            } else if (this.isLeftEdge(d2)) {
                if (d3 < d4) {
                    this.setCursor(Cursor.NW_RESIZE);
                } else if (d3 > this.getHeight() - d4) {
                    this.setCursor(Cursor.SW_RESIZE);
                } else {
                    this.setCursor(Cursor.W_RESIZE);
                }
            } else if (this.isTopEdge(d3)) {
                this.setCursor(Cursor.N_RESIZE);
            } else if (this.isBottomEdge(d3)) {
                this.setCursor(Cursor.S_RESIZE);
            } else {
                this.setCursor(Cursor.DEFAULT);
            }
        }
    }

    private void handleDragEventOnDecoratorPane(MouseEvent mouseEvent) {
        this.isDragging = true;
        if (!mouseEvent.isPrimaryButtonDown() || this.xOffset == -1.0 && this.yOffset == -1.0) {
            return;
        }
        if (this.primaryStage.isFullScreen() || mouseEvent.isStillSincePress() || this.primaryStage.isMaximized() || this.maximized) {
            return;
        }
        this.newX = mouseEvent.getScreenX();
        this.newY = mouseEvent.getScreenY();
        double d2 = this.newX - this.initX;
        double d3 = this.newY - this.initY;
        Cursor cursor = this.getCursor();
        if (Cursor.E_RESIZE.equals(cursor)) {
            this.setStageWidth(this.initWidth + d2);
            mouseEvent.consume();
        } else if (Cursor.NE_RESIZE.equals(cursor)) {
            if (this.setStageHeight(this.initHeight - d3)) {
                this.primaryStage.setY(this.initStageY + d3);
            }
            this.setStageWidth(this.initWidth + d2);
            mouseEvent.consume();
        } else if (Cursor.SE_RESIZE.equals(cursor)) {
            this.setStageWidth(this.initWidth + d2);
            this.setStageHeight(this.initHeight + d3);
            mouseEvent.consume();
        } else if (Cursor.S_RESIZE.equals(cursor)) {
            this.setStageHeight(this.initHeight + d3);
            mouseEvent.consume();
        } else if (Cursor.W_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - d2)) {
                this.primaryStage.setX(this.initStageX + d2);
            }
            mouseEvent.consume();
        } else if (Cursor.SW_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - d2)) {
                this.primaryStage.setX(this.initStageX + d2);
            }
            this.setStageHeight(this.initHeight + d3);
            mouseEvent.consume();
        } else if (Cursor.NW_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - d2)) {
                this.primaryStage.setX(this.initStageX + d2);
            }
            if (this.setStageHeight(this.initHeight - d3)) {
                this.primaryStage.setY(this.initStageY + d3);
            }
            mouseEvent.consume();
        } else if (Cursor.N_RESIZE.equals(cursor)) {
            if (this.setStageHeight(this.initHeight - d3)) {
                this.primaryStage.setY(this.initStageY + d3);
            }
            mouseEvent.consume();
        } else if (this.allowMove) {
            this.primaryStage.setX(mouseEvent.getScreenX() - this.xOffset);
            this.primaryStage.setY(mouseEvent.getScreenY() - this.yOffset);
            mouseEvent.consume();
        }
    }

    private void updateInitMouseValues(MouseEvent mouseEvent) {
        this.initStageX = this.primaryStage.getX();
        this.initStageY = this.primaryStage.getY();
        this.initWidth = this.primaryStage.getWidth();
        this.initHeight = this.primaryStage.getHeight();
        this.initX = mouseEvent.getScreenX();
        this.initY = mouseEvent.getScreenY();
        this.xOffset = mouseEvent.getSceneX();
        this.yOffset = mouseEvent.getSceneY();
    }

    private boolean isRightEdge(double d2) {
        double d3 = this.getWidth();
        return d2 < d3 && d2 > d3 - this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isTopEdge(double d2) {
        return d2 >= 0.0 && d2 < this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isBottomEdge(double d2) {
        double d3 = this.getHeight();
        return d2 < d3 && d2 > d3 - this.contentPlaceHolder.snappedLeftInset();
    }

    private boolean isLeftEdge(double d2) {
        return d2 >= 0.0 && d2 < this.contentPlaceHolder.snappedLeftInset();
    }

    boolean setStageWidth(double d2) {
        if (d2 >= this.primaryStage.getMinWidth() && d2 >= this.buttonsContainer.getMinWidth()) {
            this.primaryStage.setWidth(d2);
            return true;
        }
        if (d2 >= this.primaryStage.getMinWidth() && d2 <= this.buttonsContainer.getMinWidth()) {
            d2 = this.buttonsContainer.getMinWidth();
            this.primaryStage.setWidth(d2);
        }
        return false;
    }

    boolean setStageHeight(double d2) {
        if (d2 >= this.primaryStage.getMinHeight() && d2 >= this.buttonsContainer.getHeight()) {
            this.primaryStage.setHeight(d2);
            return true;
        }
        if (d2 >= this.primaryStage.getMinHeight() && d2 <= this.buttonsContainer.getHeight()) {
            d2 = this.buttonsContainer.getHeight();
            this.primaryStage.setHeight(d2);
        }
        return false;
    }

    public void setOnCloseButtonAction(Runnable runnable) {
        this.onCloseButtonAction.set((Object)runnable);
    }

    public final BooleanProperty customMaximizeProperty() {
        return this.customMaximize;
    }

    public final boolean isCustomMaximize() {
        return this.customMaximizeProperty().get();
    }

    public final void setCustomMaximize(boolean bl2) {
        this.customMaximizeProperty().set(bl2);
    }

    public void setMaximized(boolean bl2) {
        if (this.maximized != bl2) {
            Platform.runLater(() -> this.btnMax.fire());
        }
    }

    public void setContent(Node node) {
        this.contentPlaceHolder.getChildren().setAll((Object[])new Node[]{node});
    }

    @Deprecated
    public void setText(String string) {
        this.setTitle(string);
    }

    @Deprecated
    public String getText() {
        return this.getTitle();
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title.unbind();
        this.title.set((Object)string);
    }

    public void setGraphic(Node node) {
        if (this.graphic != null) {
            this.graphicContainer.getChildren().remove((Object)this.graphic);
        }
        if (node != null) {
            this.graphicContainer.getChildren().add(0, (Object)node);
        }
        this.graphic = node;
    }

    public Node getGraphic() {
        return this.graphic;
    }
}

