/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;

public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final PropertyMetadata STD_REQUIRED = new PropertyMetadata(Boolean.TRUE, null, null, null, null, null, null);
    public static final PropertyMetadata STD_OPTIONAL = new PropertyMetadata(Boolean.FALSE, null, null, null, null, null, null);
    public static final PropertyMetadata STD_REQUIRED_OR_OPTIONAL = new PropertyMetadata(null, null, null, null, null, null, null);
    protected final Boolean _required;
    protected final String _description;
    protected final Integer _index;
    protected final String _defaultValue;
    protected final transient MergeInfo _mergeInfo;
    protected Nulls _valueNulls;
    protected Nulls _contentNulls;

    protected PropertyMetadata(Boolean bl2, String string, Integer n2, String string2, MergeInfo mergeInfo, Nulls nulls, Nulls nulls2) {
        this._required = bl2;
        this._description = string;
        this._index = n2;
        this._defaultValue = string2 == null || string2.isEmpty() ? null : string2;
        this._mergeInfo = mergeInfo;
        this._valueNulls = nulls;
        this._contentNulls = nulls2;
    }

    public static PropertyMetadata construct(Boolean bl2, String string, Integer n2, String string2) {
        if (string != null || n2 != null || string2 != null) {
            return new PropertyMetadata(bl2, string, n2, string2, null, null, null);
        }
        if (bl2 == null) {
            return STD_REQUIRED_OR_OPTIONAL;
        }
        return bl2 != false ? STD_REQUIRED : STD_OPTIONAL;
    }

    @Deprecated
    public static PropertyMetadata construct(boolean bl2, String string, Integer n2, String string2) {
        if (string != null || n2 != null || string2 != null) {
            return new PropertyMetadata(bl2, string, n2, string2, null, null, null);
        }
        return bl2 ? STD_REQUIRED : STD_OPTIONAL;
    }

    protected Object readResolve() {
        if (this._description == null && this._index == null && this._defaultValue == null && this._mergeInfo == null && this._valueNulls == null && this._contentNulls == null) {
            if (this._required == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return this._required != false ? STD_REQUIRED : STD_OPTIONAL;
        }
        return this;
    }

    public PropertyMetadata withDescription(String string) {
        return new PropertyMetadata(this._required, string, this._index, this._defaultValue, this._mergeInfo, this._valueNulls, this._contentNulls);
    }

    public PropertyMetadata withMergeInfo(MergeInfo mergeInfo) {
        return new PropertyMetadata(this._required, this._description, this._index, this._defaultValue, mergeInfo, this._valueNulls, this._contentNulls);
    }

    public PropertyMetadata withNulls(Nulls nulls, Nulls nulls2) {
        return new PropertyMetadata(this._required, this._description, this._index, this._defaultValue, this._mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withDefaultValue(String string) {
        if (string == null || string.isEmpty()) {
            if (this._defaultValue == null) {
                return this;
            }
            string = null;
        } else if (string.equals(this._defaultValue)) {
            return this;
        }
        return new PropertyMetadata(this._required, this._description, this._index, string, this._mergeInfo, this._valueNulls, this._contentNulls);
    }

    public PropertyMetadata withIndex(Integer n2) {
        return new PropertyMetadata(this._required, this._description, n2, this._defaultValue, this._mergeInfo, this._valueNulls, this._contentNulls);
    }

    public PropertyMetadata withRequired(Boolean bl2) {
        if (bl2 == null ? this._required == null : bl2.equals(this._required)) {
            return this;
        }
        return new PropertyMetadata(bl2, this._description, this._index, this._defaultValue, this._mergeInfo, this._valueNulls, this._contentNulls);
    }

    public String getDescription() {
        return this._description;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean hasDefaultValue() {
        return this._defaultValue != null;
    }

    public boolean isRequired() {
        return this._required != null && this._required != false;
    }

    public Boolean getRequired() {
        return this._required;
    }

    public Integer getIndex() {
        return this._index;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public MergeInfo getMergeInfo() {
        return this._mergeInfo;
    }

    public Nulls getValueNulls() {
        return this._valueNulls;
    }

    public Nulls getContentNulls() {
        return this._contentNulls;
    }

    public static final class MergeInfo {
        public final AnnotatedMember getter;
        public final boolean fromDefaults;

        protected MergeInfo(AnnotatedMember annotatedMember, boolean bl2) {
            this.getter = annotatedMember;
            this.fromDefaults = bl2;
        }

        public static MergeInfo createForDefaults(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, true);
        }

        public static MergeInfo createForTypeOverride(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, false);
        }

        public static MergeInfo createForPropertyOverride(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, false);
        }
    }
}

