/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.schubfach;

import com.fasterxml.jackson.core.io.schubfach.MathUtils;
import java.io.IOException;

public final class FloatToDecimal {
    static final int P = 24;
    private static final int W = 8;
    static final int Q_MIN = -149;
    static final int Q_MAX = 104;
    static final int E_MIN = -44;
    static final int E_MAX = 39;
    static final int C_TINY = 8;
    static final int K_MIN = -45;
    static final int K_MAX = 31;
    static final int H = 9;
    private static final int C_MIN = 0x800000;
    private static final int BQ_MASK = 255;
    private static final int T_MASK = 0x7FFFFF;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final int MASK_28 = 0xFFFFFFF;
    private static final int NON_SPECIAL = 0;
    private static final int PLUS_ZERO = 1;
    private static final int MINUS_ZERO = 2;
    private static final int PLUS_INF = 3;
    private static final int MINUS_INF = 4;
    private static final int NAN = 5;
    public static final int MAX_CHARS = 15;
    private final byte[] bytes = new byte[15];
    private int index;

    private FloatToDecimal() {
    }

    public static String toString(float f2) {
        return new FloatToDecimal().toDecimalString(f2);
    }

    public static Appendable appendTo(float f2, Appendable appendable) throws IOException {
        return new FloatToDecimal().appendDecimalTo(f2, appendable);
    }

    private String toDecimalString(float f2) {
        switch (this.toDecimal(f2)) {
            case 0: {
                return this.charsToString();
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "-0.0";
            }
            case 3: {
                return "Infinity";
            }
            case 4: {
                return "-Infinity";
            }
        }
        return "NaN";
    }

    private Appendable appendDecimalTo(float f2, Appendable appendable) throws IOException {
        switch (this.toDecimal(f2)) {
            case 0: {
                char[] cArray = new char[this.index + 1];
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = (char)this.bytes[i2];
                }
                if (appendable instanceof StringBuilder) {
                    return ((StringBuilder)appendable).append(cArray);
                }
                if (appendable instanceof StringBuffer) {
                    return ((StringBuffer)appendable).append(cArray);
                }
                for (char c2 : cArray) {
                    appendable.append(c2);
                }
                return appendable;
            }
            case 1: {
                return appendable.append("0.0");
            }
            case 2: {
                return appendable.append("-0.0");
            }
            case 3: {
                return appendable.append("Infinity");
            }
            case 4: {
                return appendable.append("-Infinity");
            }
        }
        return appendable.append("NaN");
    }

    private int toDecimal(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        int n3 = n2 & 0x7FFFFF;
        int n4 = n2 >>> 23 & 0xFF;
        if (n4 < 255) {
            this.index = -1;
            if (n2 < 0) {
                this.append(45);
            }
            if (n4 != 0) {
                int n5;
                int n6 = 150 - n4;
                int n7 = 0x800000 | n3;
                if (0 < n6 & n6 < 24 && (n5 = n7 >> n6) << n6 == n7) {
                    return this.toChars(n5, 0);
                }
                return this.toDecimal(-n6, n7, 0);
            }
            if (n3 != 0) {
                return n3 < 8 ? this.toDecimal(-149, 10 * n3, -1) : this.toDecimal(-149, n3, 0);
            }
            return n2 == 0 ? 1 : 2;
        }
        if (n3 != 0) {
            return 5;
        }
        return n2 > 0 ? 3 : 4;
    }

    private int toDecimal(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        long l2;
        int n10 = n3 & 1;
        long l3 = n3 << 2;
        long l4 = l3 + 2L;
        if (n3 != 0x800000 | n2 == -149) {
            l2 = l3 - 2L;
            n9 = MathUtils.flog10pow2(n2);
        } else {
            l2 = l3 - 1L;
            n9 = MathUtils.flog10threeQuartersPow2(n2);
        }
        int n11 = n2 + MathUtils.flog2pow10(-n9) + 33;
        long l5 = MathUtils.g1(n9) + 1L;
        int n12 = FloatToDecimal.rop(l5, l3 << n11);
        int n13 = FloatToDecimal.rop(l5, l2 << n11);
        int n14 = FloatToDecimal.rop(l5, l4 << n11);
        int n15 = n12 >> 2;
        if (n15 >= 100) {
            n8 = 10 * (int)((long)n15 * 0x66666667L >>> 34);
            n7 = n8 + 10;
            n6 = n13 + n10 <= n8 << 2 ? 1 : 0;
            int n16 = n5 = (n7 << 2) + n10 <= n14 ? 1 : 0;
            if (n6 != n5) {
                return this.toChars(n6 != 0 ? n8 : n7, n9);
            }
        }
        n8 = n15 + 1;
        n7 = n13 + n10 <= n15 << 2 ? 1 : 0;
        int n17 = n6 = (n8 << 2) + n10 <= n14 ? 1 : 0;
        if (n7 != n6) {
            return this.toChars(n7 != 0 ? n15 : n8, n9 + n4);
        }
        n5 = n12 - (n15 + n8 << 1);
        return this.toChars(n5 < 0 || n5 == 0 && (n15 & 1) == 0 ? n15 : n8, n9 + n4);
    }

    private static int rop(long l2, long l3) {
        long l4 = MathUtils.multiplyHigh(l2, l3);
        long l5 = l4 >>> 31;
        return (int)(l5 | (l4 & 0xFFFFFFFFL) + 0xFFFFFFFFL >>> 32);
    }

    private int toChars(int n2, int n3) {
        int n4 = MathUtils.flog10pow2(32 - Integer.numberOfLeadingZeros(n2));
        if ((long)n2 >= MathUtils.pow10(n4)) {
            ++n4;
        }
        int n5 = (int)((long)(n2 *= (int)MathUtils.pow10(9 - n4)) * 1441151881L >>> 57);
        int n6 = n2 - 100000000 * n5;
        if (0 < (n3 += n4) && n3 <= 7) {
            return this.toChars1(n5, n6, n3);
        }
        if (-3 < n3 && n3 <= 0) {
            return this.toChars2(n5, n6, n3);
        }
        return this.toChars3(n5, n6, n3);
    }

    private int toChars1(int n2, int n3, int n4) {
        int n5;
        int n6;
        this.appendDigit(n2);
        int n7 = this.y(n3);
        for (n6 = 1; n6 < n4; ++n6) {
            n5 = 10 * n7;
            this.appendDigit(n5 >>> 28);
            n7 = n5 & 0xFFFFFFF;
        }
        this.append(46);
        while (n6 <= 8) {
            n5 = 10 * n7;
            this.appendDigit(n5 >>> 28);
            n7 = n5 & 0xFFFFFFF;
            ++n6;
        }
        this.removeTrailingZeroes();
        return 0;
    }

    private int toChars2(int n2, int n3, int n4) {
        this.appendDigit(0);
        this.append(46);
        while (n4 < 0) {
            this.appendDigit(0);
            ++n4;
        }
        this.appendDigit(n2);
        this.append8Digits(n3);
        this.removeTrailingZeroes();
        return 0;
    }

    private int toChars3(int n2, int n3, int n4) {
        this.appendDigit(n2);
        this.append(46);
        this.append8Digits(n3);
        this.removeTrailingZeroes();
        this.exponent(n4 - 1);
        return 0;
    }

    private void append8Digits(int n2) {
        int n3 = this.y(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n4 = 10 * n3;
            this.appendDigit(n4 >>> 28);
            n3 = n4 & 0xFFFFFFF;
        }
    }

    private void removeTrailingZeroes() {
        while (this.bytes[this.index] == 48) {
            --this.index;
        }
        if (this.bytes[this.index] == 46) {
            ++this.index;
        }
    }

    private int y(int n2) {
        return (int)(MathUtils.multiplyHigh((long)(n2 + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n2) {
        this.append(69);
        if (n2 < 0) {
            this.append(45);
            n2 = -n2;
        }
        if (n2 < 10) {
            this.appendDigit(n2);
            return;
        }
        int n3 = n2 * 103 >>> 10;
        this.appendDigit(n3);
        this.appendDigit(n2 - 10 * n3);
    }

    private void append(int n2) {
        this.bytes[++this.index] = (byte)n2;
    }

    private void appendDigit(int n2) {
        this.bytes[++this.index] = (byte)(48 + n2);
    }

    private String charsToString() {
        return new String(this.bytes, 0, 0, this.index + 1);
    }
}

