/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjExceptionInternal;
import java.util.Arrays;

public class FiltersPerformance {
    private final ImageInfo iminfo;
    private double memoryA = 0.7;
    private int lastrow = -1;
    private double[] absum = new double[5];
    private double[] entropy = new double[5];
    private double[] cost = new double[5];
    private int[] histog = new int[256];
    private int lastprefered = -1;
    private boolean initdone = false;
    private double preferenceForNone = 1.0;
    public static final double[] FILTER_WEIGHTS_DEFAULT = new double[]{0.73, 1.03, 0.97, 1.11, 1.22};
    private double[] filter_weights = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0};
    private static final double LOG2NI = -1.0 / Math.log(2.0);

    public FiltersPerformance(ImageInfo imageInfo) {
        this.iminfo = imageInfo;
    }

    private void init() {
        if (this.filter_weights[0] < 0.0) {
            System.arraycopy(FILTER_WEIGHTS_DEFAULT, 0, this.filter_weights, 0, 5);
            double d2 = this.filter_weights[0];
            if (this.iminfo.bitDepth == 16) {
                d2 = 1.2;
            } else if (this.iminfo.alpha) {
                d2 = 0.8;
            } else if (this.iminfo.indexed || this.iminfo.bitDepth < 8) {
                d2 = 0.4;
            }
            this.filter_weights[0] = d2 /= this.preferenceForNone;
        }
        Arrays.fill(this.cost, 1.0);
        this.initdone = true;
    }

    public void updateFromFiltered(FilterType filterType, byte[] byArray, int n2) {
        this.updateFromRawOrFiltered(filterType, byArray, null, null, n2);
    }

    public void updateFromRaw(FilterType filterType, byte[] byArray, byte[] byArray2, int n2) {
        this.updateFromRawOrFiltered(filterType, null, byArray, byArray2, n2);
    }

    private void updateFromRawOrFiltered(FilterType filterType, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        if (!this.initdone) {
            this.init();
        }
        if (n2 != this.lastrow) {
            Arrays.fill(this.absum, Double.NaN);
            Arrays.fill(this.entropy, Double.NaN);
        }
        this.lastrow = n2;
        if (byArray != null) {
            this.computeHistogram(byArray);
        } else {
            this.computeHistogramForFilter(filterType, byArray2, byArray3);
        }
        if (filterType == FilterType.FILTER_NONE) {
            this.entropy[filterType.val] = this.computeEntropyFromHistogram();
        } else {
            this.absum[filterType.val] = this.computeAbsFromHistogram();
        }
    }

    public FilterType getPreferred() {
        int n2 = 0;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!Double.isNaN(this.absum[i2])) {
                d3 = this.absum[i2];
            } else {
                if (Double.isNaN(this.entropy[i2])) continue;
                d3 = (Math.pow(2.0, this.entropy[i2]) - 1.0) * 0.5;
            }
            d3 *= this.filter_weights[i2];
            this.cost[i2] = d3 = this.cost[i2] * this.memoryA + (1.0 - this.memoryA) * d3;
            if (!(d3 < d2)) continue;
            d2 = d3;
            n2 = i2;
        }
        this.lastprefered = n2;
        return FilterType.getByVal(this.lastprefered);
    }

    public final void computeHistogramForFilter(FilterType filterType, byte[] byArray, byte[] byArray2) {
        Arrays.fill(this.histog, 0);
        int n2 = this.iminfo.bytesPerRow;
        switch (filterType) {
            case FILTER_NONE: {
                for (int i2 = 1; i2 <= n2; ++i2) {
                    int n3 = byArray[i2] & 0xFF;
                    this.histog[n3] = this.histog[n3] + 1;
                }
                break;
            }
            case FILTER_PAETH: {
                int n4;
                for (n4 = 1; n4 <= n2; ++n4) {
                    int n5 = PngHelperInternal.filterRowPaeth(byArray[n4], 0, byArray2[n4] & 0xFF, 0);
                    this.histog[n5] = this.histog[n5] + 1;
                }
                int n6 = 1;
                n4 = this.iminfo.bytesPixel + 1;
                while (n4 <= n2) {
                    int n7 = PngHelperInternal.filterRowPaeth(byArray[n4], byArray[n6] & 0xFF, byArray2[n4] & 0xFF, byArray2[n6] & 0xFF);
                    this.histog[n7] = this.histog[n7] + 1;
                    ++n4;
                    ++n6;
                }
                break;
            }
            case FILTER_SUB: {
                int n8;
                for (n8 = 1; n8 <= this.iminfo.bytesPixel; ++n8) {
                    int n9 = byArray[n8] & 0xFF;
                    this.histog[n9] = this.histog[n9] + 1;
                }
                int n10 = 1;
                n8 = this.iminfo.bytesPixel + 1;
                while (n8 <= n2) {
                    int n11 = byArray[n8] - byArray[n10] & 0xFF;
                    this.histog[n11] = this.histog[n11] + 1;
                    ++n8;
                    ++n10;
                }
                break;
            }
            case FILTER_UP: {
                for (int i3 = 1; i3 <= this.iminfo.bytesPerRow; ++i3) {
                    int n12 = byArray[i3] - byArray2[i3] & 0xFF;
                    this.histog[n12] = this.histog[n12] + 1;
                }
                break;
            }
            case FILTER_AVERAGE: {
                int n13;
                for (n13 = 1; n13 <= this.iminfo.bytesPixel; ++n13) {
                    int n14 = (byArray[n13] & 0xFF) - (byArray2[n13] & 0xFF) / 2 & 0xFF;
                    this.histog[n14] = this.histog[n14] + 1;
                }
                int n15 = 1;
                n13 = this.iminfo.bytesPixel + 1;
                while (n13 <= n2) {
                    int n16 = (byArray[n13] & 0xFF) - ((byArray2[n13] & 0xFF) + (byArray[n15] & 0xFF)) / 2 & 0xFF;
                    this.histog[n16] = this.histog[n16] + 1;
                    ++n13;
                    ++n15;
                }
                break;
            }
            default: {
                throw new PngjExceptionInternal("Bad filter:" + (Object)((Object)filterType));
            }
        }
    }

    public void computeHistogram(byte[] byArray) {
        Arrays.fill(this.histog, 0);
        for (int i2 = 1; i2 < this.iminfo.bytesPerRow; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            this.histog[n2] = this.histog[n2] + 1;
        }
    }

    public double computeAbsFromHistogram() {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < 128; ++n2) {
            n3 += this.histog[n2] * n2;
        }
        n2 = 128;
        for (int i2 = 128; i2 > 0; --i2) {
            n3 += this.histog[n2] * i2;
            ++n2;
        }
        return (double)n3 / (double)this.iminfo.bytesPerRow;
    }

    public final double computeEntropyFromHistogram() {
        double d2 = 1.0 / (double)this.iminfo.bytesPerRow;
        double d3 = Math.log(d2);
        double d4 = 0.0;
        for (int n2 : this.histog) {
            if (n2 <= 0) continue;
            d4 += (Math.log(n2) + d3) * (double)n2;
        }
        if ((d4 *= d2 * LOG2NI) < 0.0) {
            d4 = 0.0;
        }
        return d4;
    }

    public void setPreferenceForNone(double d2) {
        this.preferenceForNone = d2;
    }

    public void tuneMemory(double d2) {
        this.memoryA = d2 == 0.0 ? 0.0 : Math.pow(this.memoryA, 1.0 / d2);
    }

    public void setFilterWeights(double[] dArray) {
        System.arraycopy(dArray, 0, this.filter_weights, 0, 5);
    }
}

