/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineArray;
import ar.com.hjg.pngj.IImageLineFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLineByte
implements IImageLine,
IImageLineArray {
    public final ImageInfo imgInfo;
    final byte[] scanline;
    final byte[] scanline2;
    protected FilterType filterType;
    final int size;

    public ImageLineByte(ImageInfo imageInfo) {
        this(imageInfo, null);
    }

    public ImageLineByte(ImageInfo imageInfo, byte[] byArray) {
        this.imgInfo = imageInfo;
        this.filterType = FilterType.FILTER_UNKNOWN;
        this.size = imageInfo.samplesPerRow;
        this.scanline = byArray != null && byArray.length >= this.size ? byArray : new byte[this.size];
        this.scanline2 = imageInfo.bitDepth == 16 ? new byte[this.size] : null;
    }

    public static IImageLineFactory<ImageLineByte> getFactory(ImageInfo imageInfo) {
        return new IImageLineFactory<ImageLineByte>(){

            @Override
            public ImageLineByte createImageLine(ImageInfo imageInfo) {
                return new ImageLineByte(imageInfo);
            }
        };
    }

    public FilterType getFilterUsed() {
        return this.filterType;
    }

    public byte[] getScanlineByte() {
        return this.scanline;
    }

    public byte[] getScanlineByte2() {
        return this.scanline2;
    }

    public String toString() {
        return " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }

    @Override
    public void readFromPngRaw(byte[] byArray, int n2, int n3, int n4) {
        this.filterType = FilterType.getByVal(byArray[0]);
        int n5 = n2 - 1;
        int n6 = (n4 - 1) * this.imgInfo.channels;
        if (this.imgInfo.bitDepth == 8) {
            if (n4 == 1) {
                System.arraycopy(byArray, 1, this.scanline, 0, n5);
            } else {
                int n7 = 1;
                int n8 = 0;
                int n9 = n3 * this.imgInfo.channels;
                while (n7 <= n5) {
                    this.scanline[n9] = byArray[n7];
                    if (++n8 == this.imgInfo.channels) {
                        n8 = 0;
                        n9 += n6;
                    }
                    ++n7;
                    ++n9;
                }
            }
        } else if (this.imgInfo.bitDepth == 16) {
            if (n4 == 1) {
                int n10 = 1;
                for (int i2 = 0; i2 < this.imgInfo.samplesPerRow; ++i2) {
                    this.scanline[i2] = byArray[n10++];
                    this.scanline2[i2] = byArray[n10++];
                }
            } else {
                int n11;
                int n12 = 1;
                int n13 = 0;
                int n14 = n11 = n3 != 0 ? n3 * this.imgInfo.channels : 0;
                while (n12 <= n5) {
                    this.scanline[n11] = byArray[n12++];
                    this.scanline2[n11] = byArray[n12++];
                    if (++n13 == this.imgInfo.channels) {
                        n13 = 0;
                        n11 += n6;
                    }
                    ++n11;
                }
            }
        } else {
            int n15 = this.imgInfo.bitDepth;
            int n16 = ImageLineHelper.getMaskForPackedFormats(n15);
            int n17 = n3 * this.imgInfo.channels;
            int n18 = 0;
            for (int i3 = 1; i3 < n2; ++i3) {
                int n19 = n16;
                int n20 = 8 - n15;
                do {
                    this.scanline[n17] = (byte)((byArray[i3] & n19) >> n20);
                    n19 >>= n15;
                    n20 -= n15;
                    ++n17;
                    if (++n18 != this.imgInfo.channels) continue;
                    n18 = 0;
                    n17 += n6;
                } while (n19 != 0 && n17 < this.size);
            }
        }
    }

    @Override
    public void writeToPngRaw(byte[] byArray) {
        byArray[0] = (byte)this.filterType.val;
        if (this.imgInfo.bitDepth == 8) {
            System.arraycopy(this.scanline, 0, byArray, 1, this.size);
            for (int i2 = 0; i2 < this.size; ++i2) {
                byArray[i2 + 1] = this.scanline[i2];
            }
        } else if (this.imgInfo.bitDepth == 16) {
            int n2 = 1;
            for (int i3 = 0; i3 < this.size; ++i3) {
                byArray[n2++] = this.scanline[i3];
                byArray[n2++] = this.scanline2[i3];
            }
        } else {
            int n3 = this.imgInfo.bitDepth;
            int n4 = 8 - n3;
            int n5 = 0;
            int n6 = 1;
            for (int i4 = 0; i4 < this.size; ++i4) {
                n5 |= this.scanline[i4] << n4;
                if ((n4 -= n3) >= 0 && i4 != this.size - 1) continue;
                byArray[n6++] = (byte)n5;
                n4 = 8 - n3;
                n5 = 0;
            }
        }
    }

    @Override
    public void endReadFromPngRaw() {
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getElem(int n2) {
        return this.scanline2 == null ? this.scanline[n2] & 0xFF : (this.scanline[n2] & 0xFF) << 8 | this.scanline2[n2] & 0xFF;
    }

    public byte[] getScanline() {
        return this.scanline;
    }

    @Override
    public ImageInfo getImageInfo() {
        return this.imgInfo;
    }

    @Override
    public FilterType getFilterType() {
        return this.filterType;
    }
}

